<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Brand;
use App\Models\Category;
use App\Models\Vidget;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Inertia\Inertia;

class VidgetController extends Controller
{
    public function template(Request $request){
        if($request->update){
            DB::table('vidgets')->delete();
            foreach ($request->allSiteTemplate as $item){
                if($item['brand'] != '' && $item['name'] != 'تبلیغات ساده' && $item['name'] != 'دسته بندی دلخواه' && $item['name'] != 'تبلیغات اسلایدری'){
                    $brand = implode(',' , $item['brand']);
                }else{
                    $brand = '';
                }
                if($item['category'] != '' && $item['name'] != 'تبلیغات ساده' && $item['name'] != 'دسته بندی دلخواه' && $item['name'] != 'تبلیغات اسلایدری'){
                    $category = implode(',' , $item['category']);
                }else{
                    $category = '';
                }
                if($item['name'] == 'تبلیغات ساده' || $item['name'] == 'دسته بندی دلخواه'){
                    Vidget::create([
                        'name'=> $item['name'],
                        'brand'=> $item['brand'],
                        'title'=> $item['title'],
                        'more'=> $item['more'],
                        'show'=> $item['show'],
                        'slug'=> $item['name'],
                        'type'=> $item['type'],
                        'count'=> $item['count'],
                        'platform'=> 0,
                    ]);
                }
                elseif ($item['name'] == 'تبلیغات اسلایدری'){
                    Vidget::create([
                        'name'=> $item['name'],
                        'slug'=> $item['name'],
                        'brand'=> $item['brand'],
                        'category'=> $item['category'],
                        'more'=> $item['more'],
                        'moreEn'=> $item['moreEn'],
                        'show'=> $item['show'],
                        'type'=> $item['type'],
                        'count'=> $item['count'],
                        'platform'=> 0,
                    ]);
                }
                elseif ($item['name'] == 'پست ویژه با تصویر'){
                    Vidget::create([
                        'name'=> $item['name'],
                        'moreEn'=> $item['moreEn'],
                        'show'=> $item['show'],
                        'type'=> $item['type'],
                        'count'=> $item['count'],
                        'slug'=> $item['name'],
                        'category'=> $category,
                        'platform'=> 0,
                        'brand'=> $brand,
                    ]);
                }
                elseif ($item['name'] == 'محصولات همراه تبلیغ'){
                    Vidget::create([
                        'name'=> $item['name'],
                        'title'=> $item['title'],
                        'more'=> $item['more'],
                        'moreEn'=> $item['moreEn'],
                        'background'=> $item['background'],
                        'show'=> $item['show'],
                        'type'=> $item['type'],
                        'count'=> $item['count'],
                        'slug'=> $item['name'],
                        'category'=> $category,
                        'platform'=> 0,
                        'brand'=> $brand,
                    ]);
                }
                else{
                    Vidget::create([
                        'name'=> $item['name'],
                        'title'=> $item['title'],
                        'more'=> $item['more'],
                        'titleEn'=> $item['titleEn'],
                        'moreEn'=> $item['moreEn'],
                        'background'=> $item['background'],
                        'show'=> $item['show'],
                        'type'=> $item['type'],
                        'count'=> $item['count'],
                        'slug'=> $item['slug'],
                        'category'=> $category,
                        'platform'=> 0,
                        'brand'=> $brand,
                    ]);
                }
            }
        }
        $category = Category::latest()->where('type' , 0)->get();
        $categoryNews = Category::latest()->where('type' , 1)->get();
        $brand = Brand::latest()->get();
        $vidgets = Vidget::where('platform' , 0)->get();
        $vidget = [];
        foreach ($vidgets as $item){
            $vidgetCategory = [
                'name'=> $item['name'],
                'title'=> $item['title'],
                'more'=> $item['more'],
                'show'=> $item['show'],
                'type'=> $item['type'],
                'count'=> $item['count'],
                'slug'=> $item['slug'],
                'titleEn'=> $item['titleEn'],
                'moreEn'=> $item['moreEn'],
                'background'=> $item['background'],
                'view'=> $item['view'],
                'category'=> [],
                'brand'=> [],
            ];
            if($item['brand'] != null){
                $vidgetCategory['brand'] = explode(',' , $item['brand']);
            }else{
                $vidgetCategory['brand'] = [];
            }
            if($item['category'] != null){
                $vidgetCategory['category'] = explode(',' , $item['category']);
            }else{
                $vidgetCategory['category'] = [];
            }
            array_push($vidget , $vidgetCategory);
        }
        return Inertia::render('Setting/SettingDesign',[
            'vidget' => $vidget,
            'category' => $category,
            'categoryNews' => $categoryNews,
            'brand' => $brand,
        ]);
    }
}
