<?php

use App\Http\Controllers\Home\AuthController;
use App\Http\Controllers\Home\SellerController;
use App\Http\Controllers\Home\SitemapController;
use App\Http\Controllers\Home\UserController;
use Illuminate\Support\Facades\Route;
use App\Models\Setting;
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::group(['prefix' => 'admin'] , function (){
    Route::get('/',  [App\Http\Controllers\Admin\PanelController::class, 'index'])->middleware(['permission:نمایش داشبورد']);
    Route::get('/logout',  [App\Http\Controllers\Admin\PanelController::class, 'logout']);

    ///////////////////////////////////// gallery
    Route::match(['get', 'post'],'/gallery',  [App\Http\Controllers\Admin\GalleryController::class, 'index'])->middleware(['permission:نمایش همه تصویر ها|حذف تصویر|ویرایش تصویر|نمایش تصویر های خودش|افزودن تصویر']);
    Route::post('/gallery/create',  [App\Http\Controllers\Admin\GalleryController::class, 'create'])->middleware(['permission:افزودن تصویر']);
    Route::post('/gallery/create-image',  [App\Http\Controllers\Admin\GalleryController::class, 'createImage'])->middleware(['permission:افزودن تصویر']);
    Route::post('/gallery/remove',  [App\Http\Controllers\Admin\GalleryController::class, 'destroy'])->middleware(['permission:حذف تصویر']);
    Route::post('/gallery/show',  [App\Http\Controllers\Admin\GalleryController::class, 'show']);
    Route::post('/gallery/crop-image',  [App\Http\Controllers\Admin\GalleryController::class, 'cropImage']);
    Route::get('/get-image',  [App\Http\Controllers\Admin\GalleryController::class, 'getImage']);

    ///////////////////////////////////// setting
    Route::get('/setting/setting-comment',  [App\Http\Controllers\Admin\SettingController::class, 'comment'])->middleware(['permission:تنظیمات دیدگاه']);
    Route::put('/setting/setting-comment',  [App\Http\Controllers\Admin\SettingController::class, 'storeComment']);
    Route::get('/setting/setting-manage',  [App\Http\Controllers\Admin\SettingController::class, 'manage'])->middleware(['permission:تنظیمات سایت']);
    Route::put('/setting/setting-manage',  [App\Http\Controllers\Admin\SettingController::class, 'storeManage']);
    Route::get('/setting/seo',  [App\Http\Controllers\Admin\SettingController::class, 'seo'])->middleware(['permission:تنظیمات سئو']);
    Route::put('/setting/seo',  [App\Http\Controllers\Admin\SettingController::class, 'storeSeo']);
    Route::get('/setting/setting-category',  [App\Http\Controllers\Admin\SettingController::class, 'settingCategory'])->middleware(['permission:تنظیمات دسته بندی ها']);
    Route::put('/setting/setting-category',  [App\Http\Controllers\Admin\SettingController::class, 'storeCategory']);
    Route::match(['post','get'],'/setting/setting-popup',  [App\Http\Controllers\Admin\SettingController::class, 'popUp'])->middleware(['permission:تنظیمات دسته بندی ها']);
    Route::match(['post','get'],'/setting/setting-design',  [App\Http\Controllers\Admin\VidgetController::class, 'template'])->middleware(['permission:تنظیمات قالب سایت']);;
    Route::match(['post','get'],'/setting/setting-pay',  [App\Http\Controllers\Admin\SettingController::class, 'pay'])->middleware(['permission:تنظیمات درگاه']);;

    /////////////////////////////////////// user
    Route::match(['get', 'post'],'/user',  [App\Http\Controllers\Admin\UserController::class, 'index'])->middleware(['permission:نمایش همه کاربر ها|حذف کاربر|نمایش کاربر های خودش|ویرایش کاربر|افزودن کاربر']);
    Route::post('/user/create',  [App\Http\Controllers\Admin\UserController::class, 'store'])->middleware(['permission:افزودن کاربر']);
    Route::get('/user/{user}/edit',  [App\Http\Controllers\Admin\UserController::class, 'edit'])->middleware(['permission:ویرایش کاربر']);
    Route::put('/user/{user}',  [App\Http\Controllers\Admin\UserController::class, 'update'])->middleware(['permission:ویرایش کاربر']);
    Route::post('/user/remove',  [App\Http\Controllers\Admin\UserController::class, 'removeArray'])->middleware(['permission:حذف کاربر']);
    Route::get('/user/{user}/show',  [App\Http\Controllers\Admin\UserController::class, 'show'])->middleware(['permission:نمایش همه کاربر ها|نمایش کاربر های خودش']);

    /////////////////////////////////////// search
    Route::post('/search-gallery',  [App\Http\Controllers\Admin\SearchController::class, 'searchGallery']);
    Route::post('/search-tax',  [App\Http\Controllers\Admin\SearchController::class, 'tax']);
    Route::post('/search-product',  [App\Http\Controllers\Admin\SearchController::class, 'product']);
    Route::post('/tax/create',  [App\Http\Controllers\Admin\SearchController::class, 'createTax']);

    /////////////////////////////////////// role
    Route::match(['get', 'post'],'/role',  [App\Http\Controllers\Admin\RoleController::class, 'index'])->middleware(['permission:نمایش مقام|حذف مقام|ویرایش مقام|افزودن مقام']);
    Route::match(['get', 'post'],'/user/role',  [App\Http\Controllers\Admin\RoleController::class, 'user'])->middleware(['permission:نمایش کارمندان']);

    /////////////////////////////////////// view
    Route::match(['get', 'post'],'/view',  [App\Http\Controllers\Admin\ViewController::class, 'index'])->middleware(['permission:نمایش بازدید|حذف بازدید']);

    /////////////////////////////////////// tax
    Route::match(['get', 'post'],'/category',  [App\Http\Controllers\Admin\CategoryController::class, 'index'])->middleware(['permission:نمایش همه دسته ها|حذف دسته|ویرایش دسته|نمایش دسته های خودش|افزودن دسته']);
    Route::match(['get', 'post'],'/tag',  [App\Http\Controllers\Admin\TagController::class, 'index'])->middleware(['permission:نمایش همه برچسب ها|نمایش برچسب های خودش|حذف برچسب|ویرایش برچسب|افزودن برچسب']);
    Route::match(['get', 'post'],'/brand',  [App\Http\Controllers\Admin\BrandController::class, 'index'])->middleware(['permission:نمایش همه برند ها|نمایش برند های خودش|حذف برند|ویرایش برند|افزودن برند']);
    Route::match(['get', 'post'],'/guarantee',  [App\Http\Controllers\Admin\GuaranteeController::class, 'index'])->middleware(['permission:نمایش همه برند ها|نمایش برند های خودش|حذف برند|ویرایش برند|افزودن برند']);
    Route::match(['get', 'post'],'/page',  [App\Http\Controllers\Admin\PageController::class, 'index'])->middleware(['permission:نمایش برگه|حذف برگه|ویرایش برگه|افزودن برگه']);

    /////////////////////////////////////// ticket
    Route::match(['get', 'post'],'/ticket',  [App\Http\Controllers\Admin\TicketController::class, 'index'])->middleware(['permission:نمایش درخواست|حذف درخواست|ویرایش درخواست']);
    Route::get('/ticket/{ticket}/edit',  [App\Http\Controllers\Admin\TicketController::class, 'edit'])->middleware(['permission:ویرایش درخواست']);
    Route::put('/ticket/{ticket}',  [App\Http\Controllers\Admin\TicketController::class, 'update'])->middleware(['permission:ویرایش درخواست']);
    Route::post('/ticket/remove',  [App\Http\Controllers\Admin\TicketController::class, 'removeArray'])->middleware(['permission:حذف درخواست']);
    Route::post('/mail',  [App\Http\Controllers\Admin\MailController::class, 'email'])->middleware(['permission:فرستادن ایمیل']);

    /////////////////////////////////////// post
    Route::match(['get', 'post'],'/post',  [App\Http\Controllers\Admin\PostController::class, 'index'])->middleware(['permission:نمایش همه کالا ها|نمایش کالا های خودش|حذف کالا|ویرایش کالا|افزودن کالا']);
    Route::match(['get' , 'post'],'/post/create',  [App\Http\Controllers\Admin\PostController::class, 'create'])->middleware(['permission:افزودن کالا']);
    Route::match(['post','get'],'/post/{post}/edit',  [App\Http\Controllers\Admin\PostController::class, 'edit'])->middleware(['permission:ویرایش کالا']);
    Route::match(['post','get'],'/post/{post}/show',  [App\Http\Controllers\Admin\PostController::class, 'show'])->middleware(['permission:نمایش کالا']);

    /////////////////////////////////////// inventory
    Route::match(['get', 'post'],'/inventory',  [App\Http\Controllers\Admin\InventoryController::class, 'index'])->middleware(['permission:نمایش انبارداری']);

    /////////////////////////////////////// variety
    Route::match(['get', 'post'],'/variety',  [App\Http\Controllers\Admin\VarietyController::class, 'index'])->middleware(['permission:نمایش تنوع|حذف تنوع|ویرایش تنوع']);
    Route::match(['get' , 'post'],'/variety/{post}/create',  [App\Http\Controllers\Admin\VarietyController::class, 'create'])->middleware(['permission:افزودن تنوع']);
    Route::match(['post','get'],'/variety/{post}/edit',  [App\Http\Controllers\Admin\VarietyController::class, 'edit'])->middleware(['permission:ویرایش تنوع']);
    Route::match(['post','get'],'/variety/{post}/show',  [App\Http\Controllers\Admin\VarietyController::class, 'show'])->middleware(['permission:ویرایش تنوع']);

    /////////////////////////////////////// news
    Route::match(['get', 'post'],'/news',  [App\Http\Controllers\Admin\NewsController::class, 'index'])->middleware(['permission:نمایش همه خبر ها|نمایش خبر های خودش|حذف خبر|ویرایش خبر|افزودن خبر']);
    Route::match(['get' , 'post'],'/news/create',  [App\Http\Controllers\Admin\NewsController::class, 'create'])->middleware(['permission:افزودن خبر']);
    Route::match(['post','get'],'/news/{news}/edit',  [App\Http\Controllers\Admin\NewsController::class, 'edit'])->middleware(['permission:ویرایش خبر']);

    ////////////////////////////////////////////////////////////////////////////////////// pay
    Route::match(['get', 'post'],'/pay',  [App\Http\Controllers\Admin\PayController::class, 'index'])->middleware(['permission:نمایش پرداختی|حذف پرداختی']);
    Route::match(['get', 'post'],'/pay/chart',  [App\Http\Controllers\Admin\PayController::class, 'chart'])->middleware(['permission:نمایش پرداختی|حذف پرداختی']);
    Route::get('/pay/{pay}',  [App\Http\Controllers\Admin\PayController::class, 'show'])->middleware(['permission:نمایش پرداختی']);
    Route::match(['get', 'post'],'/show-pay/{pay}',  [App\Http\Controllers\Admin\PayController::class, 'showPay'])->middleware(['permission:نمایش پرداختی']);
    Route::match(['get', 'post'],'/pay/create',  [App\Http\Controllers\Admin\PayController::class, 'create'])->middleware(['permission:نمایش پرداختی|حذف پرداختی']);
    Route::get('/pay/invoice/{pay}',  [App\Http\Controllers\Admin\PayController::class, 'invoice'])->name('invoice')->middleware(['permission:نمایش پرداختی']);

    /////////////////////////////////////// comment
    Route::match(['get', 'post'],'/comment',  [App\Http\Controllers\Admin\CommentController::class, 'index'])->middleware(['permission:ویرایش دیدگاه|حذف دیدگاه']);
    Route::match(['get', 'post'],'/comment/{comment}',  [App\Http\Controllers\Admin\CommentController::class, 'edit'])->middleware(['permission:ویرایش دیدگاه']);

    ///////////////////////////////////////// notification
    Route::match(['get', 'post'],'/notification/sms',  [App\Http\Controllers\Admin\NotificationController::class, 'sms'])->middleware(['permission:نمایش همه اطلاع رسانی ها|حذف اطلاع رسانی|نمایش اطلاع رسانی های خودش|افزودن اطلاع رسانی']);
    Route::match(['get', 'post'],'/notification/email',  [App\Http\Controllers\Admin\NotificationController::class, 'email'])->middleware(['permission:نمایش همه اطلاع رسانی ها|حذف اطلاع رسانی|نمایش اطلاع رسانی های خودش|افزودن اطلاع رسانی']);

    ///////////////////////////////////////// robot
    Route::match(['get', 'post'],'/robot',  [App\Http\Controllers\Admin\RobotController::class, 'index'])->middleware(['permission:نمایش همه رباط ها|حذف رباط|نمایش رباط های خودش|افزودن رباط']);

    ///////////////////////////////////////// country
    Route::match(['get', 'post'],'/country',  [App\Http\Controllers\Admin\CountryController::class, 'index'])->middleware(['permission:افزودن کشور']);

    ///////////////////////////////////////// ask
    Route::match(['get', 'post'],'/ask',  [App\Http\Controllers\Admin\AskController::class, 'index'])->middleware(['permission:افزودن کشور']);

    ///////////////////////////////////////// discount
    Route::match(['get', 'post'],'/discount',  [App\Http\Controllers\Admin\DiscountController::class, 'index'])->middleware(['permission:افزودن کد تخفیف']);

    ///////////////////////////////////////// link
    Route::match(['get', 'post'],'/link',  [App\Http\Controllers\Admin\LinkController::class, 'index'])->middleware(['permission:افزودن لینک']);

    ///////////////////////////////////////// carrier
    Route::match(['get', 'post'],'/carrier',  [App\Http\Controllers\Admin\CarrierController::class, 'index'])->middleware(['permission:نمایش همه رباط ها|حذف رباط|نمایش رباط های خودش|افزودن رباط']);

    ///////////////////////////////////////// time
    Route::match(['get', 'post'],'/time',  [App\Http\Controllers\Admin\TimeController::class, 'index'])->middleware(['permission:نمایش همه رباط ها|حذف رباط|نمایش رباط های خودش|افزودن رباط']);

    ///////////////////////////////////////// seller
    Route::match(['get', 'post'],'/seller',  [App\Http\Controllers\Admin\SellerController::class, 'index'])->middleware(['permission:نمایش فروشنده']);

    ///////////////////////////////////////// checkout
    Route::match(['get', 'post'],'/checkout',  [App\Http\Controllers\Admin\CheckoutController::class, 'index'])->middleware(['permission:نمایش تسویه حساب ها']);

    ///////////////////////////////////////// document
    Route::match(['get', 'post'],'/document',  [App\Http\Controllers\Admin\DocumentController::class, 'index'])->middleware(['permission:نمایش مدارک']);

    ///////////////////////////////////////// question
    Route::match(['get', 'post'],'/question',  [App\Http\Controllers\Admin\QuestionController::class, 'index'])->middleware(['permission:نمایش پرسش و پاسخ|حذف پرسش و پاسخ|ویرایش پرسش و پاسخ']);

    ///////////////////////////////////////// event
    Route::match(['get', 'post'],'/event',  [App\Http\Controllers\Admin\EventController::class, 'index'])->middleware(['permission:نمایش رویداد|حذف رویداد']);
    Route::match(['get', 'post'],'/report/feedback',  [App\Http\Controllers\Admin\ReportController::class, 'feedback'])->middleware(['permission:نمایش بازخورد|حذف بازخورد']);
    Route::match(['get', 'post'],'/report/notification',  [App\Http\Controllers\Admin\ReportController::class, 'notification'])->middleware(['permission:نمایش اطلاع پست|حذف اطلاع پست']);

    ///////////////////////////////////////// excel
    Route::match(['get', 'post'],'/excel',  [App\Http\Controllers\Admin\ExcelController::class, 'index'])->middleware(['permission:نمایش رویداد|حذف رویداد']);
    Route::get('/get-excel/{data}',  [App\Http\Controllers\Admin\ExcelController::class, 'getExcel'])->middleware(['permission:نمایش رویداد|حذف رویداد']);

});
Route::group(['prefix' => '/'] , function (){
    Route::get('/',  [App\Http\Controllers\Home\IndexController::class, 'index']);
    Route::get('/page/{PageSlug}',  [App\Http\Controllers\Home\IndexController::class, 'page']);
    Route::post('/show-compares',  [App\Http\Controllers\Home\IndexController::class, 'showCompares']);

    ///////////////////////////////////////////////////////////////// single
    Route::get('/product/{PostSlug}',  [App\Http\Controllers\Home\SingleController::class, 'product']);
    Route::post('/send-report',  [App\Http\Controllers\Home\ReportController::class, 'sendReport']);
    Route::post('/send-question',  [App\Http\Controllers\Home\QuestionController::class, 'sendQuestion']);
    Route::post('/send-call',  [App\Http\Controllers\Home\QuestionController::class, 'sendCall']);
    Route::post('/change-seller',  [App\Http\Controllers\Home\SingleController::class, 'changeSeller']);
    Route::post('/view',  [App\Http\Controllers\Home\SingleController::class, 'view']);
    Route::get('/blog/{NewsSlug}',  [App\Http\Controllers\Home\SingleController::class, 'news']);

    //////////////////////////////////////////////// cart
    Route::post('/add-cart',  [App\Http\Controllers\Home\CartController::class, 'addCart']);
    Route::post('/add-cart2',  [App\Http\Controllers\Home\CartController::class, 'addCart2']);
    Route::get('/get-carts',  [App\Http\Controllers\Home\CartController::class, 'getCarts']);
    Route::get('/cart',  [App\Http\Controllers\Home\CartController::class, 'cart']);
    Route::get('/cart-address',  [App\Http\Controllers\Home\CartController::class, 'cartAddress']);
    Route::post('/delete-cart',  [App\Http\Controllers\Home\CartController::class, 'deleteCart']);
    Route::post('/change-cart',  [App\Http\Controllers\Home\CartController::class, 'changeCart']);
    Route::post('/change-carrier',  [App\Http\Controllers\Home\CartController::class, 'changeCarrier']);
    Route::post('/change-time-delivery',  [App\Http\Controllers\Home\CartController::class, 'changeTimeDelivery']);
    Route::post('/check-discount',  [App\Http\Controllers\Home\CartController::class, 'checkDiscount']);

    /////////////////////////////////////////////// like
    Route::get('/get-like',  [App\Http\Controllers\Home\LikeController::class, 'getLike']);
    Route::post('/like',  [App\Http\Controllers\Home\LikeController::class, 'store']);

    /////////////////////////////////////////////// bookmark
    Route::get('/get-bookmark',  [App\Http\Controllers\Home\BookmarkController::class, 'getBookmark']);
    Route::post('/bookmark',  [App\Http\Controllers\Home\BookmarkController::class, 'store']);

    ///////////////////////////////////////////////////// address
    Route::post('/add-address',  [App\Http\Controllers\Home\AddressController::class, 'create']);
    Route::get('/get-all-address',  [App\Http\Controllers\Home\AddressController::class, 'getAll']);
    Route::post('/edit-address',  [App\Http\Controllers\Home\AddressController::class, 'editAddress']);
    Route::post('/select-address',  [App\Http\Controllers\Home\AddressController::class, 'selectAddress']);
    Route::post('/delete-address',  [App\Http\Controllers\Home\AddressController::class, 'deleteAddress']);
    Route::post('/edit-user-address',  [App\Http\Controllers\Home\AddressController::class, 'editUserAddress']);

    ///////////////////////////////////////////////////// comment
    Route::post('/send-comment',  [App\Http\Controllers\Home\CommentController::class, 'sendComment']);
    Route::post('/get-comment',  [App\Http\Controllers\Home\CommentController::class, 'getComment']);
    Route::post('/send-reply',  [App\Http\Controllers\Home\CommentController::class, 'sendReply']);

    ///////////////////////////////////////////////////////////////// Archive
    Route::get('/products/category/{CategorySlug}',  [App\Http\Controllers\Home\ArchiveController::class, 'category']);
    Route::get('/change/products/category/{CategorySlug}',  [App\Http\Controllers\Home\ArchiveController::class, 'categoryChange']);
    Route::get('/products/widget/{WidgetSlug}',  [App\Http\Controllers\Home\ArchiveController::class, 'widget']);
    Route::get('/change/products/widget/{WidgetSlug}',  [App\Http\Controllers\Home\ArchiveController::class, 'widgetChange']);
    Route::get('/products/brand/{BrandSlug}',  [App\Http\Controllers\Home\ArchiveController::class, 'brand']);
    Route::get('/change/products/brand/{BrandSlug}',  [App\Http\Controllers\Home\ArchiveController::class, 'brandChange']);
    Route::get('/products/search/',  [App\Http\Controllers\Home\ArchiveController::class, 'search']);
    Route::get('/change/products/search',  [App\Http\Controllers\Home\ArchiveController::class, 'searchChange']);
    Route::post('/search-nav',  [App\Http\Controllers\Home\ArchiveController::class, 'searchNav']);
    Route::get('/products/country/{CountrySlug}',  [App\Http\Controllers\Home\ArchiveController::class, 'country']);
    Route::get('/change/products/country/{CountrySlug}',  [App\Http\Controllers\Home\ArchiveController::class, 'countryChange']);
    Route::get('/blog/category/{CategoryNewsSlug}',  [App\Http\Controllers\Home\ArchiveController::class, 'categoryBlog']);
    Route::get('/change/blog/category/{CategoryNewsSlug}',  [App\Http\Controllers\Home\ArchiveController::class, 'categoryBlogChange']);
    Route::get('/blog/tag/{TagSlug}',  [App\Http\Controllers\Home\ArchiveController::class, 'tagBlog']);
    Route::get('/change/blog/tag/{TagSlug}',  [App\Http\Controllers\Home\ArchiveController::class, 'tagBlogChange']);
    Route::get('/blog',  [App\Http\Controllers\Home\ArchiveController::class, 'blog']);
    Route::get('/change/blog',  [App\Http\Controllers\Home\ArchiveController::class, 'blogChange']);

    ///////////////////////////////////////////////////// rate
    Route::post('/rate',  [App\Http\Controllers\Home\RateController::class, 'store']);
    Route::post('/get-rate',  [App\Http\Controllers\Home\RateController::class, 'getRate']);

    ///////////////////////////////////////////////////// ticket
    Route::get('/ticket',  [App\Http\Controllers\Home\TicketController::class, 'index']);
    Route::post('/send-ticket',  [App\Http\Controllers\Home\TicketController::class, 'sendTicket']);

    ////////////////////////////////////////////////////// profile
    Route::get('/profile',  [UserController::class, 'profile']);
    Route::get('/profile/pay',  [UserController::class, 'pay']);
    Route::get('/profile/bookmark',  [UserController::class, 'bookmark']);
    Route::get('/profile/like',  [UserController::class, 'like']);
    Route::get('/profile/comment',  [UserController::class, 'comment']);
    Route::delete('/profile/comment/{comment}/delete',  [UserController::class, 'deleteComment']);
    Route::get('/profile/ticket',  [UserController::class, 'ticket']);
    Route::delete('/profile/ticket/{ticket}/delete',  [UserController::class, 'deleteTicket']);
    Route::get('/profile/personal-info',  [UserController::class, 'personalInfo']);
    Route::put('/change-all-user-info/{user}',  [UserController::class, 'ChangeAllUserInfo']);
    Route::get('/show-pay/{PayProperty}',  [UserController::class, 'showPay'])->name('showPay');
    Route::get('/pay/invoice/{PayProperty}',  [UserController::class, 'invoice'])->name('invoice');

    ////////////////////////////////////////////////////// seller
    Route::get('/seller',  [SellerController::class, 'becomeSeller']);
    Route::post('/seller',  [SellerController::class, 'becomeSellerStore']);
    Route::get('/seller/profile',  [SellerController::class, 'profile']);
    Route::get('/seller/product/create',  [SellerController::class, 'createProduct']);
    Route::post('/seller/product/create',  [SellerController::class, 'addProduct']);
    Route::get('/seller/product/{MyProduct}/edit',  [SellerController::class, 'editProduct']);
    Route::get('/seller/product/user',  [SellerController::class, 'allMyProduct']);
    Route::get('/seller/product/all',  [SellerController::class, 'allProduct']);
    Route::get('/seller/checkout',  [SellerController::class, 'checkout']);
    Route::post('/seller/checkout',  [SellerController::class, 'checkoutStore']);
    Route::get('/seller/pay',  [SellerController::class, 'pay']);
    Route::get('/seller/variety',  [SellerController::class, 'variety']);
    Route::get('/seller/pay/{MyPay}',  [SellerController::class, 'showPay']);
    Route::get('/seller/add-variety/{MyProduct}',  [SellerController::class, 'addVariety']);
    Route::post('/seller/add-variety/{MyProduct}',  [SellerController::class, 'addVarietyStore']);
    Route::get('/seller/edit-variety/{MyVariety}',  [SellerController::class, 'editVariety']);
    Route::post('/seller/edit-variety/{MyVariety}',  [SellerController::class, 'editVarietyStore']);
    Route::post('/seller/search-product',  [SellerController::class, 'searchProduct']);
    Route::post('/seller/search-my-product',  [SellerController::class, 'searchMyProduct']);

    ///////////////////////////////////////////////////// shop
    Route::get('/order',  [App\Http\Controllers\Home\ShopController::class, 'order']);
    Route::get('/order/zibal',  [App\Http\Controllers\Home\ShopController::class, 'zibal']);
    Route::get('/order/nextPay',  [App\Http\Controllers\Home\ShopController::class, 'nextPay']);
    Route::get('/order/idpay',  [App\Http\Controllers\Home\ShopController::class, 'idpay']);
    Route::get('/shop',  [App\Http\Controllers\Home\ShopController::class, 'add_order']);
    Route::get('/payment-spot',  [App\Http\Controllers\Home\ShopController::class, 'paymentSpot']);
    Route::get('/spot/order',  [App\Http\Controllers\Home\ShopController::class, 'spotOrder']);
    Route::get('/spot/order/zibal',  [App\Http\Controllers\Home\ShopController::class, 'spotZibal']);
    Route::get('/spot/order/nextPay',  [App\Http\Controllers\Home\ShopController::class, 'spotNextPay']);
    Route::get('/spot/order/idpay',  [App\Http\Controllers\Home\ShopController::class, 'spotIdpay']);

    ////////////////////////////////////////////////////// google
    Route::get('/google-login', [App\Http\Controllers\Home\GoogleController::class, 'redirectToProvider']);
    Route::get('/callback', [App\Http\Controllers\Home\GoogleController::class, 'handleProviderCallback']);

    //////////////////////////////////////// upload
    Route::post('/create-image',  [UserController::class, 'createImage']);
    Route::post('/change-profile',  [UserController::class, 'changeProfile']);

    ////////////////////////////////////////////////////////////// auth
    Route::get('/login',  [AuthController::class, 'loginPage'])->name('login');
    Route::get('/register',  [AuthController::class, 'loginPage'])->name('register');

    Route::feeds();
    ///////////////////////////////////////////////////// sitemap
    Route::get('/sitemap.xml' , [SitemapController::class , 'index']);
    Route::get('/sitemap-products' , [SitemapController::class , 'products']);
    Route::get('/sitemap-categories' , [SitemapController::class , 'categories']);
    Route::get('/sitemap-brands' , [SitemapController::class , 'brands']);
    Route::get('/sitemap-tags' , [SitemapController::class , 'tags']);
    Route::get('/sitemap-countries' , [SitemapController::class , 'countries']);

    /**/// number
    Route::post('/check-auth',  [AuthController::class, 'check']);
    Route::post('/check-code',  [AuthController::class, 'checkCode']);
    Route::post('/login-auth',  [AuthController::class, 'login']);
    Route::get('/logout',  [AuthController::class, 'logout']);
    Route::post('/make-user',  [AuthController::class, 'makeUser']);
    Route::post('/change-password',  [AuthController::class, 'changePassword']);

    /**/// email
    Route::post('/check-email',  [AuthController::class, 'checkEmail']);
    Route::post('/check-email-code',  [AuthController::class, 'checkEmailCode']);
    Route::post('/login-email',  [AuthController::class, 'loginEmail']);
    Route::post('/change-email-password',  [AuthController::class, 'changeEmailPassword']);
    Route::post('/make-user-email',  [AuthController::class, 'makeUserEmail']);

    Route::get('/seller/{SellerSlug}',  [App\Http\Controllers\Home\SingleController::class, 'seller']);
    Route::get('/{PostId}',  [App\Http\Controllers\Home\SingleController::class, 'product']);
});
