<?php

namespace App\Exports;

use App\Models\PayMeta;
use Carbon\Carbon;
use Illuminate\Contracts\View\View;
use Maatwebsite\Excel\Concerns\FromView;

class PayMetaExport implements FromView
{
    protected $invoices;

    public function __construct($invoices)
    {
        if ($invoices == 'allPayMeta'){
            $this->invoices = PayMeta::all();
        }
        if ($invoices == 'todayPayMeta'){
            $this->invoices = PayMeta::whereDate('created_at',Carbon::today())->get();
        }
    }

    public function view(): View
    {
        $invoices = $this->invoices;
        return view('exports.paymeta',compact('invoices'));
    }
}
