<?php

namespace App\Http\Controllers\Home;

use App\Http\Controllers\Controller;
use App\Http\Resources\ProductResource;
use App\Models\Brand;
use App\Models\Category;
use App\Models\Country;
use App\Models\News;
use App\Models\Post;
use App\Models\Setting;
use App\Models\Vidget;
use App\Traits\SeoHelper;
use Illuminate\Http\Request;
use Inertia\Inertia;

class ArchiveController extends Controller
{
    use SeoHelper;
    public function category(Request $request , Category $CategorySlug){
        $category = $CategorySlug;
        $name = Category::where('id' , $category->id)->pluck('name')->first();
        $title = Setting::where('key' , 'title')->pluck('value')->first();
        $logo = Setting::where('key' , 'logo')->pluck('value')->first() ?:'' ;
        $shortActivity = Setting::where('key' , 'descriptionSeo')->pluck('value')->first() ?:'' ;
        $this->seoSingleSeo(   $category->name . " - $title " , $shortActivity , 'store' , 'archive/category'."$category->slug" , $logo );
        $maxPrice = $category->post()->where('status' , 1)->orderBy('price','DESC')->pluck('price')->first();
        $minPrice = $category->post()->where('status' , 1)->orderBy('price')->pluck('price')->first();
        if($request->max){
            $getshowmax = $request->max;
        }else{
            $getshowmax = $category->post()->where('status' , 1)->orderBy('price','DESC')->pluck('price')->first();
        }
        if($request->min){
            $getshowmin = $request->min;
        }else{
            $getshowmin = $category->post()->where('status' , 1)->orderBy('price')->pluck('price')->first();
        }
        if($request->search){
            $getsearch = $request->search;
        }else{
            $getsearch = '';
        }
        if($request->show){
            $getshow = $request->show;
        }else{
            $getshow = 0;
        }
        if($request->allSize){
            $getsize = explode(',',$request->allSize);
        }else{
            $getsize = [];
        }
        if($request->allColor){
            $getcolor = explode(',',$request->allColor);
        }else{
            $getcolor = [];
        }
        $post = $category->post()->where('status' , 1)->with('review')->get();
        $color1 = [];
        for ( $i = 0; $i < count($post); $i++) {
            $colors = json_decode($post[$i]['review'][0]['colors']);
            if ($colors != null){
                for ( $i2 = 0; $i2 < count($colors); $i2++) {
                    array_push($color1 , $colors[$i2]->name);
                }
            }
        }
        $color = array_unique($color1);

        $size1 = [];
        for ( $i = 0; $i < count($post); $i++) {
            $sizes = json_decode($post[$i]['review'][0]['size'] , true);
            if ($sizes != null){
                for ( $i2 = 0; $i2 < count($sizes); $i2++) {
                    array_push($size1 , $sizes[$i2]['name']);
                }
            }
        }
        $size = array_unique($size1);

        $ability = [];
        $check = 'no';
        for ( $i = 0; $i < count($post); $i++) {
            $abilities = json_decode($post[$i]['review'][0]['ability'] , true);
            if ($abilities != null){
                for ( $i2 = 0; $i2 < count($abilities); $i2++) {
                    for ( $i3 = 0; $i3 < count($ability); $i3++) {
                        if ($ability[$i3] == $abilities[$i2]){
                            $check = 'yes';
                        }
                    }
                    if ($check == 'no'){
                        array_push($ability , $abilities[$i2]);
                    }
                    $check = 'no';
                }
            }
        }

        $brands = Brand::latest()->get();

        $cats = Category::where('id' , $category->id)->with(["cats" => function($q){
            $q->latest()
                ->with(["post" => function($q){
                    $q->latest()->where('status',1);
                }])
                ->with(["cats" => function($q){
                    $q->latest()->with(["cats" => function($q){
                        $q->latest()->with('cats');
                    }]);
                }]);
        }])->get();
        $url = 'category/';
        $urlpages = '/change/products/category/'.$category->slug;
        return view('home.archive.product', compact('cats','name','getsize','getcolor','getsearch','getshow','getshowmin','getshowmax','urlpages','url','minPrice','maxPrice','size','ability','brands','color'));
    }
    public function categoryChange(Request $request , Category $CategorySlug){
        $category = $CategorySlug;
        $post = $category->post()->where('status' , 1)->with('review')->get();
        if ($request->allAbility){
            $abilityId = [];
            for ( $i = 0; $i < count($post); $i++) {
                $abilitiesIds = json_decode($post[$i]['review'][0]['ability'],true);
                if ($abilitiesIds != null){
                    for ( $i2 = 0; $i2 < count($abilitiesIds); $i2++) {
                        for ( $i3 = 0; $i3 < count($request->allAbility); $i3++) {
                            if ($request->allAbility[$i3] == $abilitiesIds[$i2]['name']){
                                array_push($abilityId , $post[$i]['id']);
                            }
                        }
                    }
                }
            }
        }else{
            $abilityId = $category->post()->where('status' , 1)->pluck('id')->toArray();
        }

        if ($request->allSize){
            $allSize = explode(',' , $request->allSize);
            $sizeId = [];
            for ( $i = 0; $i < count($post); $i++) {
                $sizeIds = json_decode($post[$i]['review'][0]['size'] , true);
                if ($sizeIds != null){
                    for ( $i2 = 0; $i2 < count($sizeIds); $i2++) {
                        for ( $i3 = 0; $i3 < count($allSize); $i3++) {
                            if ($allSize[$i3] == $sizeIds[$i2]['name']){
                                array_push($sizeId , $post[$i]['id']);
                            }
                        }
                    }
                }
            }
        }else{
            $sizeId = $category->post()->where('status' , 1)->pluck('id')->toArray();
        }

        if ($request->search){
            $searchId = $category->post()->latest()->where("title" , "LIKE" , "%{$request->search}%")->where('status' , 1)->pluck('id')->toArray();
        }else{
            $searchId = $category->post()->where('status' , 1)->pluck('id')->toArray();
        }

        if ($request->allColor){
            $allColor = explode(',' , $request->allColor);
            $colorId = [];
            for ( $i = 0; $i < count($post); $i++) {
                $colorIds = json_decode($post[$i]['review'][0]['colors'] , true);
                if ($colorIds != null){
                    for ( $i2 = 0; $i2 < count($colorIds); $i2++) {
                        for ( $i3 = 0; $i3 < count($allColor); $i3++) {
                            if ($allColor[$i3] == $colorIds[$i2]['name']){
                                array_push($colorId , $post[$i]['id']);
                            }
                        }
                    }
                }
            }
        }else{
            $colorId = $category->post()->where('status' , 1)->pluck('id')->toArray();
        }
        if ($request->max){
            $rangeId = $category->post()->where('price', '>=', $request->min)->where('status' , 1)->where('price', '<=', $request->max)->pluck('id')->toArray();
        }else{
            $rangeId = $category->post()->where('status' , 1)->pluck('id')->toArray();
        }

        if ($request->suggest){
            $suggestId = $category->post()->where('suggest' , '!=' , null)->where('status' , 1)->pluck('id')->toArray();
        }else{
            $suggestId = $category->post()->where('status' , 1)->pluck('id')->toArray();
        }

        if ($request->count){
            $countId = $category->post()->where('count' , '!=' , '0')->where('status' , 1)->pluck('id')->toArray();
        }else{
            $countId = $category->post()->where('status' , 1)->pluck('id')->toArray();
        }

        if ($request->allBrands){
            $brandId1 = [];
            $brandId = [];
            for ( $i = 0; $i < count($request->allBrands); $i++) {
                $brandCheck1 = Brand::where('name', $request->allBrands[$i])->first();
                $brandCheck = $brandCheck1->post()->pluck('id');
                array_push($brandId1 , $brandCheck);
            }
            for ( $i = 0; $i < count($brandId1[0]); $i++) {
                $send = Post::where('id' , $brandId1[0][$i])->pluck('id')->first();
                array_push($brandId , $send);
            }
        }else{
            $brandId = $category->post()->where('status' , 1)->pluck('id')->toArray();
        }

        $arrayFilter = array_intersect($brandId, $rangeId,$colorId,$searchId,$countId,$suggestId,$sizeId,$abilityId);

        $showPostPage = Setting::where('key' , 'showPostPage')->pluck('value')->first();

        if ($request->show == 0){
            $catPost = $category->post()->where('variety' , 0)->latest()->whereIn('id' , $arrayFilter)->where('status' , 1)->with('review')->paginate($showPostPage);
        }
        if ($request->show == 2){
            $catPost = $category->post()->where('variety' , 0)->withCount('payMeta')->orderBy('pay_meta_count','DESC' )->whereIn('id' , $arrayFilter)->where('status' , 1)->with('review')->paginate($showPostPage);
        }
        if ($request->show == 1 or $request->show == 3){
            $catPost = $category->post()->where('variety' , 0)->withCount('view')->orderBy('view_count','DESC' )->whereIn('id' , $arrayFilter)->where('status' , 1)->with('review')->paginate($showPostPage);
        }
        if ($request->show == 4){
            $catPost = $category->post()->where('variety' , 0)->orderBy('price')->whereIn('id' , $arrayFilter)->where('status' , 1)->with('review')->paginate($showPostPage);
        }
        if ($request->show == 5){
            $catPost = $category->post()->where('variety' , 0)->orderBy('price','DESC')->whereIn('id' , $arrayFilter)->where('status' , 1)->with('review')->paginate($showPostPage);
        }
        return $catPost;
    }

    public function widget(Request $request , Vidget $WidgetSlug){
        $vidget = $WidgetSlug;
        $title = Setting::where('key' , 'title')->pluck('value')->first();
        $logo = Setting::where('key' , 'logo')->pluck('value')->first() ?:'' ;
        $shortActivity = Setting::where('key' , 'descriptionSeo')->pluck('value')->first() ?:'' ;
        $this->seoSingleSeo(    " $title " , $shortActivity , 'store' , "archive/products?".$vidget->slug , $logo );

        $ids = [];
        $ids2 = [];
        if($vidget['category'] != '' && $vidget['name'] != 'خبر ها' && $vidget['name'] != 'تبلیغات ساده' && $vidget['name'] != 'اسلایدر بزرگ تبلیغ' && $vidget['name'] != 'تبلیغات اسلایدری'){
            $allCatSite3 = explode(',' , $vidget['category']);
            foreach ($allCatSite3 as $value){
                $tax = Category::where('name' , $value)->first();
                $send2 = $tax->post()->pluck('id')->toArray();
                foreach ($send2 as $data){
                    array_push($ids ,$data);
                }
            }
        }
        if($vidget['brand'] != '' && $vidget['name'] != 'خبر ها' && $vidget['name'] != 'تبلیغات ساده' && $vidget['name'] != 'پیشنهاد شگفت انگیز' && $vidget['name'] != 'اسلایدر بزرگ تبلیغ' && $vidget['name'] != 'تبلیغات اسلایدری'){
            $allBrandSite3 = explode(',' , $vidget['brand']);
            foreach ($allBrandSite3 as $value){
                $tax = Brand::where('name' , $value)->first();
                $send2 = $tax->post()->pluck('id')->toArray();
                foreach ($send2 as $data){
                    array_push($ids2 ,$data);
                }
            }
        }
        if($ids && $ids2){
            $id3 = array_intersect($ids2, $ids);
        }else{
            if($ids){
                $id3 = $ids;
            }elseif($ids2){
                $id3 = $ids;
            }else{
                $id3 = Post::where('status' , 1)->where('variety' , 0)->take(500)->pluck('id');
            }
        }

        $maxPrice = Post::whereIn('id' , $id3)->where('status' , 1)->orderBy('price','DESC')->pluck('price')->first();
        $minPrice = Post::whereIn('id' , $id3)->where('status' , 1)->orderBy('price')->pluck('price')->first();
        if($request->max){
            $getshowmax = $request->max;
        }else{
            $getshowmax = Post::whereIn('id' , $id3)->where('status' , 1)->orderBy('price','DESC')->pluck('price')->first();
        }
        if($request->min){
            $getshowmin = $request->min;
        }else{
            $getshowmin = Post::whereIn('id' , $id3)->where('status' , 1)->orderBy('price')->pluck('price')->first();
        }
        if($request->search){
            $getsearch = $request->search;
        }else{
            $getsearch = '';
        }
        if($request->show){
            $getshow = $request->show;
        }else{
            $getshow = 0;
        }
        if($request->allSize){
            $getsize = explode(',',$request->allSize);
        }else{
            $getsize = [];
        }
        if($request->allColor){
            $getcolor = explode(',',$request->allColor);
        }else{
            $getcolor = [];
        }
        $post = Post::whereIn('id' , $id3)->where('status' , 1)->with('review')->get();
        $color1 = [];
        for ( $i = 0; $i < count($post); $i++) {
            $colors = json_decode($post[$i]['review'][0]['colors']);
            if ($colors != null){
                for ( $i2 = 0; $i2 < count($colors); $i2++) {
                    array_push($color1 , $colors[$i2]->name);
                }
            }
        }
        $color = array_unique($color1);

        $size1 = [];
        for ( $i = 0; $i < count($post); $i++) {
            $sizes = json_decode($post[$i]['review'][0]['size'] , true);
            if ($sizes != null){
                for ( $i2 = 0; $i2 < count($sizes); $i2++) {
                    array_push($size1 , $sizes[$i2]['name']);
                }
            }
        }
        $size = array_unique($size1);

        $ability = [];
        $check = 'no';
        for ( $i = 0; $i < count($post); $i++) {
            $abilities = json_decode($post[$i]['review'][0]['ability'] , true);
            if ($abilities != null){
                for ( $i2 = 0; $i2 < count($abilities); $i2++) {
                    for ( $i3 = 0; $i3 < count($ability); $i3++) {
                        if ($ability[$i3] == $abilities[$i2]){
                            $check = 'yes';
                        }
                    }
                    if ($check == 'no'){
                        array_push($ability , $abilities[$i2]);
                    }
                    $check = 'no';
                }
            }
        }

        $brands = Brand::latest()->get();
        $cats = collect([['slug' => $vidget->slug ,'name' => $vidget->title , 'cats'=> []]]);
        $url = 'widget/';
        $urlpages = '/change/products/widget/'.$vidget->slug;
        $name = $vidget->title;
        return view('home.archive.product', compact('cats','name','getsize','getcolor','getsearch','getshow','getshowmin','getshowmax','urlpages','url','minPrice','maxPrice','size','ability','brands','color'));
    }
    public function widgetChange(Request $request , Vidget $WidgetSlug){
        $vidget = $WidgetSlug;
        $ids = [];
        $ids2 = [];
        if($vidget['category'] != '' && $vidget['name'] != 'خبر ها' && $vidget['name'] != 'تبلیغات ساده' && $vidget['name'] != 'اسلایدر بزرگ تبلیغ' && $vidget['name'] != 'تبلیغات اسلایدری'){
            $allCatSite3 = explode(',' , $vidget['category']);
            foreach ($allCatSite3 as $value){
                $tax = Category::where('name' , $value)->first();
                $send2 = $tax->post()->pluck('id')->toArray();
                foreach ($send2 as $data){
                    array_push($ids ,$data);
                }
            }
        }
        if($vidget['brand'] != '' && $vidget['name'] != 'خبر ها' && $vidget['name'] != 'تبلیغات ساده' && $vidget['name'] != 'پیشنهاد شگفت انگیز' && $vidget['name'] != 'اسلایدر بزرگ تبلیغ' && $vidget['name'] != 'تبلیغات اسلایدری'){
            $allBrandSite3 = explode(',' , $vidget['brand']);
            foreach ($allBrandSite3 as $value){
                $tax = Brand::where('name' , $value)->first();
                $send2 = $tax->post()->pluck('id')->toArray();
                foreach ($send2 as $data){
                    array_push($ids2 ,$data);
                }
            }
        }
        if($ids && $ids2){
            $id3 = array_intersect($ids2, $ids);
        }else{
            if($ids){
                $id3 = $ids;
            }elseif($ids2){
                $id3 = $ids;
            }else{
                $id3 = Post::where('status' , 1)->where('variety' , 0)->take(500)->pluck('id');
            }
        }

        $post = Post::whereIn('id' , $id3)->where('status' , 1)->with('review')->get();
        if ($request->allAbility){
            $abilityId = [];
            for ( $i = 0; $i < count($post); $i++) {
                $abilitiesIds = json_decode($post[$i]['review'][0]['ability'],true);
                if ($abilitiesIds != null){
                    for ( $i2 = 0; $i2 < count($abilitiesIds); $i2++) {
                        for ( $i3 = 0; $i3 < count($request->allAbility); $i3++) {
                            if ($request->allAbility[$i3] == $abilitiesIds[$i2]['name']){
                                array_push($abilityId , $post[$i]['id']);
                            }
                        }
                    }
                }
            }
        }else{
            $abilityId = Post::whereIn('id' , $id3)->where('status' , 1)->pluck('id')->toArray();
        }

        if ($request->allSize){
            $allSize = explode(',' , $request->allSize);
            $sizeId = [];
            for ( $i = 0; $i < count($post); $i++) {
                $sizeIds = json_decode($post[$i]['review'][0]['size'] , true);
                if ($sizeIds != null){
                    for ( $i2 = 0; $i2 < count($sizeIds); $i2++) {
                        for ( $i3 = 0; $i3 < count($allSize); $i3++) {
                            if ($allSize[$i3] == $sizeIds[$i2]['name']){
                                array_push($sizeId , $post[$i]['id']);
                            }
                        }
                    }
                }
            }
        }else{
            $sizeId = Post::whereIn('id' , $id3)->where('status' , 1)->pluck('id')->toArray();
        }

        if ($request->search){
            $searchId = Post::whereIn('id' , $id3)->latest()->where("title" , "LIKE" , "%{$request->search}%")->where('status' , 1)->pluck('id')->toArray();
        }else{
            $searchId = Post::whereIn('id' , $id3)->where('status' , 1)->pluck('id')->toArray();
        }

        if ($request->allColor){
            $allColor = explode(',' , $request->allColor);
            $colorId = [];
            for ( $i = 0; $i < count($post); $i++) {
                $colorIds = json_decode($post[$i]['review'][0]['colors'] , true);
                if ($colorIds != null){
                    for ( $i2 = 0; $i2 < count($colorIds); $i2++) {
                        for ( $i3 = 0; $i3 < count($allColor); $i3++) {
                            if ($allColor[$i3] == $colorIds[$i2]['name']){
                                array_push($colorId , $post[$i]['id']);
                            }
                        }
                    }
                }
            }
        }else{
            $colorId = Post::whereIn('id' , $id3)->where('status' , 1)->pluck('id')->toArray();
        }
        if ($request->max){
            $rangeId = Post::whereIn('id' , $id3)->where('price', '>=', $request->min)->where('status' , 1)->where('price', '<=', $request->max)->pluck('id')->toArray();
        }else{
            $rangeId = Post::whereIn('id' , $id3)->where('status' , 1)->pluck('id')->toArray();
        }

        if ($request->suggest){
            $suggestId = Post::whereIn('id' , $id3)->where('suggest' , '!=' , null)->where('status' , 1)->pluck('id')->toArray();
        }else{
            $suggestId = Post::whereIn('id' , $id3)->where('status' , 1)->pluck('id')->toArray();
        }

        if ($request->count){
            $countId = Post::whereIn('id' , $id3)->where('count' , '!=' , '0')->where('status' , 1)->pluck('id')->toArray();
        }else{
            $countId = Post::whereIn('id' , $id3)->where('status' , 1)->pluck('id')->toArray();
        }

        if ($request->allBrands){
            $brandId1 = [];
            $brandId = [];
            for ( $i = 0; $i < count($request->allBrands); $i++) {
                $brandCheck1 = Brand::where('name', $request->allBrands[$i])->first();
                $brandCheck = $brandCheck1->post()->pluck('id');
                array_push($brandId1 , $brandCheck);
            }
            for ( $i = 0; $i < count($brandId1[0]); $i++) {
                $send = Post::where('id' , $brandId1[0][$i])->pluck('id')->first();
                array_push($brandId , $send);
            }
        }else{
            $brandId = Post::whereIn('id' , $id3)->where('status' , 1)->pluck('id')->toArray();
        }

        $arrayFilter = array_intersect($brandId, $rangeId,$colorId,$searchId,$countId,$suggestId,$sizeId,$abilityId);

        $showPostPage = Setting::where('key' , 'showPostPage')->pluck('value')->first();

        if ($request->show == 0){
            if($vidget['type'] == 3){
                $catPost = Post::whereIn('id',$id3)->where('type' , 0)->where('variety' , 0)->latest()->whereIn('id' , $arrayFilter)->where('status' , 1)->with('review')->paginate($showPostPage);
            }
            if($vidget['type'] == 0){
                $catPost = Post::whereIn('id',$id3)->where('type' , 0)->where('variety' , 0)->where('count' , '>=' , 1)->latest()->whereIn('id' , $arrayFilter)->where('status' , 1)->with('review')->paginate($showPostPage);
            }
            if($vidget['type'] == 1){
                $catPost = Post::whereIn('id',$id3)->where('type' , 0)->where('variety' , 0)->where('off' , '!=' , null)->latest()->whereIn('id' , $arrayFilter)->where('status' , 1)->with('review')->paginate($showPostPage);
            }
            if($vidget['type'] == 2){
                $catPost = Post::whereIn('id',$id3)->where('type' , 0)->where('variety' , 0)->where('suggest' , '!=' , null)->latest()->whereIn('id' , $arrayFilter)->where('status' , 1)->with('review')->paginate($showPostPage);
            }
        }
        if ($request->show == 2){
            if($vidget['type'] == 3){
                $catPost = Post::whereIn('id',$id3)->where('type' , 0)->where('variety' , 0)->withCount('payMeta')->orderBy('pay_meta_count','DESC' )->whereIn('id' , $arrayFilter)->where('status' , 1)->with('review')->paginate($showPostPage);
            }
            if($vidget['type'] == 0){
                $catPost = Post::whereIn('id',$id3)->where('type' , 0)->where('variety' , 0)->where('count' , '>=' , 1)->withCount('payMeta')->orderBy('pay_meta_count','DESC' )->whereIn('id' , $arrayFilter)->where('status' , 1)->with('review')->paginate($showPostPage);
            }
            if($vidget['type'] == 1){
                $catPost = Post::whereIn('id',$id3)->where('type' , 0)->where('variety' , 0)->where('off' , '!=' , null)->withCount('payMeta')->orderBy('pay_meta_count','DESC' )->whereIn('id' , $arrayFilter)->where('status' , 1)->with('review')->paginate($showPostPage);
            }
            if($vidget['type'] == 2){
                $catPost = Post::whereIn('id',$id3)->where('type' , 0)->where('variety' , 0)->where('suggest' , '!=' , null)->withCount('payMeta')->orderBy('pay_meta_count','DESC' )->whereIn('id' , $arrayFilter)->where('status' , 1)->with('review')->paginate($showPostPage);
            }
        }
        if ($request->show == 1 or $request->show == 3){
            if($vidget['type'] == 3){
                $catPost = Post::whereIn('id',$id3)->where('type' , 0)->where('variety' , 0)->withCount('view')->orderBy('view_count','DESC' )->whereIn('id' , $arrayFilter)->where('status' , 1)->with('review')->paginate($showPostPage);
            }
            if($vidget['type'] == 0){
                $catPost = Post::whereIn('id',$id3)->where('type' , 0)->where('variety' , 0)->where('count' , '>=' , 1)->withCount('view')->orderBy('view_count','DESC' )->whereIn('id' , $arrayFilter)->where('status' , 1)->with('review')->paginate($showPostPage);
            }
            if($vidget['type'] == 1){
                $catPost = Post::whereIn('id',$id3)->where('type' , 0)->where('variety' , 0)->where('off' , '!=' , null)->withCount('view')->orderBy('view_count','DESC' )->whereIn('id' , $arrayFilter)->where('status' , 1)->with('review')->paginate($showPostPage);
            }
            if($vidget['type'] == 2){
                $catPost = Post::whereIn('id',$id3)->where('type' , 0)->where('variety' , 0)->where('suggest' , '!=' , null)->withCount('view')->orderBy('view_count','DESC' )->whereIn('id' , $arrayFilter)->where('status' , 1)->with('review')->paginate($showPostPage);
            }
        }
        if ($request->show == 4){
            if($vidget['type'] == 3){
                $catPost = Post::whereIn('id',$id3)->where('type' , 0)->where('variety' , 0)->orderBy('price')->whereIn('id' , $arrayFilter)->where('status' , 1)->with('review')->paginate($showPostPage);
            }
            if($vidget['type'] == 0){
                $catPost = Post::whereIn('id',$id3)->where('type' , 0)->where('variety' , 0)->where('count' , '>=' , 1)->orderBy('price')->whereIn('id' , $arrayFilter)->where('status' , 1)->with('review')->paginate($showPostPage);
            }
            if($vidget['type'] == 1){
                $catPost = Post::whereIn('id',$id3)->where('type' , 0)->where('variety' , 0)->where('off' , '!=' , null)->orderBy('price')->whereIn('id' , $arrayFilter)->where('status' , 1)->with('review')->paginate($showPostPage);
            }
            if($vidget['type'] == 2){
                $catPost = Post::whereIn('id',$id3)->where('type' , 0)->where('variety' , 0)->where('suggest' , '!=' , null)->orderBy('price')->whereIn('id' , $arrayFilter)->where('status' , 1)->with('review')->paginate($showPostPage);
            }
        }
        if ($request->show == 5){
            if($vidget['type'] == 3){
                $catPost = Post::whereIn('id',$id3)->where('type' , 0)->where('variety' , 0)->orderBy('price','DESC')->whereIn('id' , $arrayFilter)->where('status' , 1)->with('review')->paginate($showPostPage);
            }
            if($vidget['type'] == 0){
                $catPost = Post::whereIn('id',$id3)->where('type' , 0)->where('variety' , 0)->where('count' , '>=' , 1)->orderBy('price','DESC')->whereIn('id' , $arrayFilter)->where('status' , 1)->with('review')->paginate($showPostPage);
            }
            if($vidget['type'] == 1){
                $catPost = Post::whereIn('id',$id3)->where('type' , 0)->where('variety' , 0)->where('off' , '!=' , null)->orderBy('price','DESC')->whereIn('id' , $arrayFilter)->where('status' , 1)->with('review')->paginate($showPostPage);
            }
            if($vidget['type'] == 2){
                $catPost = Post::whereIn('id',$id3)->where('type' , 0)->where('variety' , 0)->where('suggest' , '!=' , null)->orderBy('price','DESC')->whereIn('id' , $arrayFilter)->where('status' , 1)->with('review')->paginate($showPostPage);
            }
        }
        return $catPost;
    }

    public function country(Request $request , Country $CountrySlug){
        $country = $CategoryNewsSlug;
        $name = Category::where('id' , $country->id)->pluck('name')->first();
        $title = Setting::where('key' , 'title')->pluck('value')->first();
        $logo = Setting::where('key' , 'logo')->pluck('value')->first() ?:'' ;
        $shortActivity = Setting::where('key' , 'descriptionSeo')->pluck('value')->first() ?:'' ;
        $this->seoSingleSeo(   $country->name . " - $title " , $shortActivity , 'store' , 'archive/country'."$country->slug" , $logo );

        $maxPrice = $country->post()->where('status' , 1)->orderBy('price','DESC')->pluck('price')->first();
        $minPrice = $country->post()->where('status' , 1)->orderBy('price')->pluck('price')->first();
        if($request->max){
            $getshowmax = $request->max;
        }else{
            $getshowmax = $country->post()->where('status' , 1)->orderBy('price','DESC')->pluck('price')->first();
        }
        if($request->min){
            $getshowmin = $request->min;
        }else{
            $getshowmin = $country->post()->where('status' , 1)->orderBy('price')->pluck('price')->first();
        }
        if($request->search){
            $getsearch = $request->search;
        }else{
            $getsearch = '';
        }
        if($request->show){
            $getshow = $request->show;
        }else{
            $getshow = 0;
        }
        if($request->allSize){
            $getsize = explode(',',$request->allSize);
        }else{
            $getsize = [];
        }
        if($request->allColor){
            $getcolor = explode(',',$request->allColor);
        }else{
            $getcolor = [];
        }
        $post = $country->post()->where('status' , 1)->with('review')->get();
        $color1 = [];
        for ( $i = 0; $i < count($post); $i++) {
            $colors = json_decode($post[$i]['review'][0]['colors']);
            if ($colors != null){
                for ( $i2 = 0; $i2 < count($colors); $i2++) {
                    array_push($color1 , $colors[$i2]->name);
                }
            }
        }
        $color = array_unique($color1);

        $size1 = [];
        for ( $i = 0; $i < count($post); $i++) {
            $sizes = json_decode($post[$i]['review'][0]['size'] , true);
            if ($sizes != null){
                for ( $i2 = 0; $i2 < count($sizes); $i2++) {
                    array_push($size1 , $sizes[$i2]['name']);
                }
            }
        }
        $size = array_unique($size1);

        $ability = [];
        $check = 'no';
        for ( $i = 0; $i < count($post); $i++) {
            $abilities = json_decode($post[$i]['review'][0]['ability'] , true);
            if ($abilities != null){
                for ( $i2 = 0; $i2 < count($abilities); $i2++) {
                    for ( $i3 = 0; $i3 < count($ability); $i3++) {
                        if ($ability[$i3] == $abilities[$i2]){
                            $check = 'yes';
                        }
                    }
                    if ($check == 'no'){
                        array_push($ability , $abilities[$i2]);
                    }
                    $check = 'no';
                }
            }
        }

        $brands = Brand::latest()->get();

        $cats = collect([['slug' => $country->slug ,'name' => $country->name , 'cats'=> []]]);

        $url = 'country/';
        $urlpages = '/change/products/country/'.$country->slug;
        return view('home.archive.product', compact('cats','name','getsize','getcolor','getsearch','getshow','getshowmin','getshowmax','urlpages','url','minPrice','maxPrice','size','ability','brands','color'));
    }
    public function countryChange(Request $request , Country $CategoryNewsSlug){
        $country = $CategoryNewsSlug;
        $post = $country->post()->where('status' , 1)->with('review')->get();
        if ($request->allAbility){
            $abilityId = [];
            for ( $i = 0; $i < count($post); $i++) {
                $abilitiesIds = json_decode($post[$i]['review'][0]['ability'],true);
                if ($abilitiesIds != null){
                    for ( $i2 = 0; $i2 < count($abilitiesIds); $i2++) {
                        for ( $i3 = 0; $i3 < count($request->allAbility); $i3++) {
                            if ($request->allAbility[$i3] == $abilitiesIds[$i2]['name']){
                                array_push($abilityId , $post[$i]['id']);
                            }
                        }
                    }
                }
            }
        }else{
            $abilityId = $country->post()->where('status' , 1)->pluck('id')->toArray();
        }

        if ($request->allSize){
            $allSize = explode(',' , $request->allSize);
            $sizeId = [];
            for ( $i = 0; $i < count($post); $i++) {
                $sizeIds = json_decode($post[$i]['review'][0]['size'] , true);
                if ($sizeIds != null){
                    for ( $i2 = 0; $i2 < count($sizeIds); $i2++) {
                        for ( $i3 = 0; $i3 < count($allSize); $i3++) {
                            if ($allSize[$i3] == $sizeIds[$i2]['name']){
                                array_push($sizeId , $post[$i]['id']);
                            }
                        }
                    }
                }
            }
        }else{
            $sizeId = $country->post()->where('status' , 1)->pluck('id')->toArray();
        }

        if ($request->search){
            $searchId = $country->post()->latest()->where("title" , "LIKE" , "%{$request->search}%")->where('status' , 1)->pluck('id')->toArray();
        }else{
            $searchId = $country->post()->where('status' , 1)->pluck('id')->toArray();
        }

        if ($request->allColor){
            $allColor = explode(',' , $request->allColor);
            $colorId = [];
            for ( $i = 0; $i < count($post); $i++) {
                $colorIds = json_decode($post[$i]['review'][0]['colors'] , true);
                if ($colorIds != null){
                    for ( $i2 = 0; $i2 < count($colorIds); $i2++) {
                        for ( $i3 = 0; $i3 < count($allColor); $i3++) {
                            if ($allColor[$i3] == $colorIds[$i2]['name']){
                                array_push($colorId , $post[$i]['id']);
                            }
                        }
                    }
                }
            }
        }else{
            $colorId = $country->post()->where('status' , 1)->pluck('id')->toArray();
        }
        if ($request->max){
            $rangeId = $country->post()->where('price', '>=', $request->min)->where('status' , 1)->where('price', '<=', $request->max)->pluck('id')->toArray();
        }else{
            $rangeId = $country->post()->where('status' , 1)->pluck('id')->toArray();
        }

        if ($request->suggest){
            $suggestId = $country->post()->where('suggest' , '!=' , null)->where('status' , 1)->pluck('id')->toArray();
        }else{
            $suggestId = $country->post()->where('status' , 1)->pluck('id')->toArray();
        }

        if ($request->count){
            $countId = $country->post()->where('count' , '!=' , '0')->where('status' , 1)->pluck('id')->toArray();
        }else{
            $countId = $country->post()->where('status' , 1)->pluck('id')->toArray();
        }

        if ($request->allBrands){
            $brandId1 = [];
            $brandId = [];
            for ( $i = 0; $i < count($request->allBrands); $i++) {
                $brandCheck1 = Brand::where('name', $request->allBrands[$i])->first();
                $brandCheck = $brandCheck1->post()->pluck('id');
                array_push($brandId1 , $brandCheck);
            }
            for ( $i = 0; $i < count($brandId1[0]); $i++) {
                $send = Post::where('id' , $brandId1[0][$i])->pluck('id')->first();
                array_push($brandId , $send);
            }
        }else{
            $brandId = $country->post()->where('status' , 1)->pluck('id')->toArray();
        }

        $arrayFilter = array_intersect($brandId, $rangeId,$colorId,$searchId,$countId,$suggestId,$sizeId,$abilityId);

        $showPostPage = Setting::where('key' , 'showPostPage')->pluck('value')->first();

        if ($request->show == 0){
            $catPost = $country->post()->where('variety' , 0)->latest()->whereIn('id' , $arrayFilter)->where('status' , 1)->with('review')->paginate($showPostPage);
        }
        if ($request->show == 2){
            $catPost = $country->post()->where('variety' , 0)->withCount('payMeta')->orderBy('pay_meta_count','DESC' )->whereIn('id' , $arrayFilter)->where('status' , 1)->with('review')->paginate($showPostPage);
        }
        if ($request->show == 1 or $request->show == 3){
            $catPost = $country->post()->where('variety' , 0)->withCount('view')->orderBy('view_count','DESC' )->whereIn('id' , $arrayFilter)->where('status' , 1)->with('review')->paginate($showPostPage);
        }
        if ($request->show == 4){
            $catPost = $country->post()->where('variety' , 0)->orderBy('price')->whereIn('id' , $arrayFilter)->where('status' , 1)->with('review')->paginate($showPostPage);
        }
        if ($request->show == 5){
            $catPost = $country->post()->where('variety' , 0)->orderBy('price','DESC')->whereIn('id' , $arrayFilter)->where('status' , 1)->with('review')->paginate($showPostPage);
        }
        return $catPost;
    }

    public function search(Request $request){
        $address = Setting::where('key' , 'address')->pluck('value')->first() ?:'' ;
        $title = Setting::where('key' , 'title')->pluck('value')->first();
        $logo = Setting::where('key' , 'logo')->pluck('value')->first() ?:'' ;
        $body = Setting::where('key' , 'descriptionSeo')->pluck('value')->first() ?:'' ;
        $this->seoSingleSeo(   $request->search . " - $title " , $body , 'store' , "archive/search?search=".$request->search , $logo );

        $maxPrice = Post::where("title" , "LIKE" , "%{$request->search}%")->where('status' , 1)->orderBy('price','DESC')->pluck('price')->first();
        $minPrice = Post::where("title" , "LIKE" , "%{$request->search}%")->where('status' , 1)->orderBy('price')->pluck('price')->first();
        if($request->max){
            $getshowmax = $request->max;
        }else{
            $getshowmax = Post::where("title" , "LIKE" , "%{$request->search}%")->where('status' , 1)->orderBy('price','DESC')->pluck('price')->first();
        }
        if($request->min){
            $getshowmin = $request->min;
        }else{
            $getshowmin = Post::where("title" , "LIKE" , "%{$request->search}%")->where('status' , 1)->orderBy('price')->pluck('price')->first();
        }
        if($request->search){
            $getsearch = $request->search;
        }else{
            $getsearch = '';
        }
        if($request->show){
            $getshow = $request->show;
        }else{
            $getshow = 0;
        }
        if($request->allSize){
            $getsize = explode(',',$request->allSize);
        }else{
            $getsize = [];
        }
        if($request->allColor){
            $getcolor = explode(',',$request->allColor);
        }else{
            $getcolor = [];
        }
        $post = Post::where("title" , "LIKE" , "%{$request->search}%")->where('status' , 1)->with('review')->get();
        $color1 = [];
        for ( $i = 0; $i < count($post); $i++) {
            $colors = json_decode($post[$i]['review'][0]['colors']);
            if ($colors != null){
                for ( $i2 = 0; $i2 < count($colors); $i2++) {
                    array_push($color1 , $colors[$i2]->name);
                }
            }
        }
        $color = array_unique($color1);

        $size1 = [];
        for ( $i = 0; $i < count($post); $i++) {
            $sizes = json_decode($post[$i]['review'][0]['size'] , true);
            if ($sizes != null){
                for ( $i2 = 0; $i2 < count($sizes); $i2++) {
                    array_push($size1 , $sizes[$i2]['name']);
                }
            }
        }
        $size = array_unique($size1);

        $ability = [];
        $check = 'no';
        for ( $i = 0; $i < count($post); $i++) {
            $abilities = json_decode($post[$i]['review'][0]['ability'] , true);
            if ($abilities != null){
                for ( $i2 = 0; $i2 < count($abilities); $i2++) {
                    for ( $i3 = 0; $i3 < count($ability); $i3++) {
                        if ($ability[$i3] == $abilities[$i2]){
                            $check = 'yes';
                        }
                    }
                    if ($check == 'no'){
                        array_push($ability , $abilities[$i2]);
                    }
                    $check = 'no';
                }
            }
        }

        $brands = Brand::latest()->get();

        $cats = collect([['slug' => '' ,'name' => $request->search , 'cats'=> []]]);

        $url = 'search?'.$request->search;
        $urlpages = '/change/products/search?search='.$request->search;
        $name = $request->search;
        return view('home.archive.product', compact('cats','name','getsize','getcolor','getsearch','getshow','getshowmin','getshowmax','urlpages','url','minPrice','maxPrice','size','ability','brands','color'));
    }
    public function searchChange(Request $request){
        $post = Post::where("title" , "LIKE" , "%{$request->search}%")->where('status' , 1)->with('review')->get();
        if ($request->allAbility){
            $abilityId = [];
            for ( $i = 0; $i < count($post); $i++) {
                $abilitiesIds = json_decode($post[$i]['review'][0]['ability'],true);
                if ($abilitiesIds != null){
                    for ( $i2 = 0; $i2 < count($abilitiesIds); $i2++) {
                        for ( $i3 = 0; $i3 < count($request->allAbility); $i3++) {
                            if ($request->allAbility[$i3] == $abilitiesIds[$i2]['name']){
                                array_push($abilityId , $post[$i]['id']);
                            }
                        }
                    }
                }
            }
        }else{
            $abilityId = Post::where("title" , "LIKE" , "%{$request->search}%")->where('status' , 1)->pluck('id')->toArray();
        }

        if ($request->allSize){
            $allSize = explode(',' , $request->allSize);
            $sizeId = [];
            for ( $i = 0; $i < count($post); $i++) {
                $sizeIds = json_decode($post[$i]['review'][0]['size'] , true);
                if ($sizeIds != null){
                    for ( $i2 = 0; $i2 < count($sizeIds); $i2++) {
                        for ( $i3 = 0; $i3 < count($allSize); $i3++) {
                            if ($allSize[$i3] == $sizeIds[$i2]['name']){
                                array_push($sizeId , $post[$i]['id']);
                            }
                        }
                    }
                }
            }
        }else{
            $sizeId = Post::where("title" , "LIKE" , "%{$request->search}%")->where('status' , 1)->pluck('id')->toArray();
        }

        if ($request->search){
            $searchId = Post::where("title" , "LIKE" , "%{$request->search}%")->latest()->where("title" , "LIKE" , "%{$request->search}%")->where('status' , 1)->pluck('id')->toArray();
        }else{
            $searchId = Post::where("title" , "LIKE" , "%{$request->search}%")->where('status' , 1)->pluck('id')->toArray();
        }

        if ($request->allColor){
            $allColor = explode(',' , $request->allColor);
            $colorId = [];
            for ( $i = 0; $i < count($post); $i++) {
                $colorIds = json_decode($post[$i]['review'][0]['colors'] , true);
                if ($colorIds != null){
                    for ( $i2 = 0; $i2 < count($colorIds); $i2++) {
                        for ( $i3 = 0; $i3 < count($allColor); $i3++) {
                            if ($allColor[$i3] == $colorIds[$i2]['name']){
                                array_push($colorId , $post[$i]['id']);
                            }
                        }
                    }
                }
            }
        }else{
            $colorId = Post::where("title" , "LIKE" , "%{$request->search}%")->where('status' , 1)->pluck('id')->toArray();
        }
        if ($request->max){
            $rangeId = Post::where("title" , "LIKE" , "%{$request->search}%")->where('price', '>=', $request->min)->where('status' , 1)->where('price', '<=', $request->max)->pluck('id')->toArray();
        }else{
            $rangeId = Post::where("title" , "LIKE" , "%{$request->search}%")->where('status' , 1)->pluck('id')->toArray();
        }

        if ($request->suggest){
            $suggestId = Post::where("title" , "LIKE" , "%{$request->search}%")->where('suggest' , '!=' , null)->where('status' , 1)->pluck('id')->toArray();
        }else{
            $suggestId = Post::where("title" , "LIKE" , "%{$request->search}%")->where('status' , 1)->pluck('id')->toArray();
        }

        if ($request->count){
            $countId = Post::where("title" , "LIKE" , "%{$request->search}%")->where('count' , '!=' , '0')->where('status' , 1)->pluck('id')->toArray();
        }else{
            $countId = Post::where("title" , "LIKE" , "%{$request->search}%")->where('status' , 1)->pluck('id')->toArray();
        }

        if ($request->allBrands){
            $brandId1 = [];
            $brandId = [];
            for ( $i = 0; $i < count($request->allBrands); $i++) {
                $brandCheck1 = Brand::where('name', $request->allBrands[$i])->first();
                $brandCheck = $brandCheck1->post()->pluck('id');
                array_push($brandId1 , $brandCheck);
            }
            for ( $i = 0; $i < count($brandId1[0]); $i++) {
                $send = Post::where('id' , $brandId1[0][$i])->pluck('id')->first();
                array_push($brandId , $send);
            }
        }else{
            $brandId = Post::where("title" , "LIKE" , "%{$request->search}%")->where('status' , 1)->pluck('id')->toArray();
        }

        $arrayFilter = array_intersect($brandId, $rangeId,$colorId,$searchId,$countId,$suggestId,$sizeId,$abilityId);

        $showPostPage = Setting::where('key' , 'showPostPage')->pluck('value')->first();

        if ($request->show == 0){
            $catPost = Post::where("title" , "LIKE" , "%{$request->search}%")->where('variety' , 0)->latest()->whereIn('id' , $arrayFilter)->where('status' , 1)->with('review')->paginate($showPostPage);
        }
        if ($request->show == 2){
            $catPost = Post::where("title" , "LIKE" , "%{$request->search}%")->where('variety' , 0)->withCount('payMeta')->orderBy('pay_meta_count','DESC' )->whereIn('id' , $arrayFilter)->where('status' , 1)->with('review')->paginate($showPostPage);
        }
        if ($request->show == 1 or $request->show == 3){
            $catPost = Post::where("title" , "LIKE" , "%{$request->search}%")->where('variety' , 0)->withCount('view')->orderBy('view_count','DESC' )->whereIn('id' , $arrayFilter)->where('status' , 1)->with('review')->paginate($showPostPage);
        }
        if ($request->show == 4){
            $catPost = Post::where("title" , "LIKE" , "%{$request->search}%")->where('variety' , 0)->orderBy('price')->whereIn('id' , $arrayFilter)->where('status' , 1)->with('review')->paginate($showPostPage);
        }
        if ($request->show == 5){
            $catPost = Post::where("title" , "LIKE" , "%{$request->search}%")->where('variety' , 0)->orderBy('price','DESC')->whereIn('id' , $arrayFilter)->where('status' , 1)->with('review')->paginate($showPostPage);
        }
        return $catPost;
    }

    public function brand(Request $request , Brand $BrandSlug){
        $brand = $BrandSlug;
        $name = Brand::where('id' , $brand->id)->pluck('name')->first();
        $title = Setting::where('key' , 'title')->pluck('value')->first();
        $logo = Setting::where('key' , 'logo')->pluck('value')->first() ?:'' ;
        $shortActivity = Setting::where('key' , 'descriptionSeo')->pluck('value')->first() ?:'' ;
        $this->seoSingleSeo(   $brand->name . " - $title " , $shortActivity , 'store' , 'archive/brand'."$brand->slug" , $logo );
        $maxPrice = $brand->post()->where('status' , 1)->orderBy('price','DESC')->pluck('price')->first();
        $minPrice = $brand->post()->where('status' , 1)->orderBy('price')->pluck('price')->first();
        if($request->max){
            $getshowmax = $request->max;
        }else{
            $getshowmax = $brand->post()->where('status' , 1)->orderBy('price','DESC')->pluck('price')->first();
        }
        if($request->min){
            $getshowmin = $request->min;
        }else{
            $getshowmin = $brand->post()->where('status' , 1)->orderBy('price')->pluck('price')->first();
        }
        if($request->search){
            $getsearch = $request->search;
        }else{
            $getsearch = '';
        }
        if($request->show){
            $getshow = $request->show;
        }else{
            $getshow = 0;
        }
        if($request->allSize){
            $getsize = explode(',',$request->allSize);
        }else{
            $getsize = [];
        }
        if($request->allColor){
            $getcolor = explode(',',$request->allColor);
        }else{
            $getcolor = [];
        }
        $post = $brand->post()->where('status' , 1)->with('review')->get();
        $color1 = [];
        for ( $i = 0; $i < count($post); $i++) {
            $colors = json_decode($post[$i]['review'][0]['colors']);
            if ($colors != null){
                for ( $i2 = 0; $i2 < count($colors); $i2++) {
                    array_push($color1 , $colors[$i2]->name);
                }
            }
        }
        $color = array_unique($color1);

        $size1 = [];
        for ( $i = 0; $i < count($post); $i++) {
            $sizes = json_decode($post[$i]['review'][0]['size'] , true);
            if ($sizes != null){
                for ( $i2 = 0; $i2 < count($sizes); $i2++) {
                    array_push($size1 , $sizes[$i2]['name']);
                }
            }
        }
        $size = array_unique($size1);

        $ability = [];
        $check = 'no';
        for ( $i = 0; $i < count($post); $i++) {
            $abilities = json_decode($post[$i]['review'][0]['ability'] , true);
            if ($abilities != null){
                for ( $i2 = 0; $i2 < count($abilities); $i2++) {
                    for ( $i3 = 0; $i3 < count($ability); $i3++) {
                        if ($ability[$i3] == $abilities[$i2]){
                            $check = 'yes';
                        }
                    }
                    if ($check == 'no'){
                        array_push($ability , $abilities[$i2]);
                    }
                    $check = 'no';
                }
            }
        }

        $brands = Brand::latest()->get();

        $cats = collect([['slug' => $brand->slug ,'name' => $brand->name , 'cats'=> []]]);

        $url = 'brand/';
        $urlpages = '/change/products/brand/'.$brand->slug;
        return view('home.archive.product', compact('cats','name','getsize','getcolor','getsearch','getshow','getshowmin','getshowmax','urlpages','url','minPrice','maxPrice','size','ability','brands','color'));
    }
    public function brandChange(Request $request , Brand $BrandSlug){
        $brand = $BrandSlug;
        $post = $brand->post()->where('status' , 1)->with('review')->get();
        if ($request->allAbility){
            $abilityId = [];
            for ( $i = 0; $i < count($post); $i++) {
                $abilitiesIds = json_decode($post[$i]['review'][0]['ability'],true);
                if ($abilitiesIds != null){
                    for ( $i2 = 0; $i2 < count($abilitiesIds); $i2++) {
                        for ( $i3 = 0; $i3 < count($request->allAbility); $i3++) {
                            if ($request->allAbility[$i3] == $abilitiesIds[$i2]['name']){
                                array_push($abilityId , $post[$i]['id']);
                            }
                        }
                    }
                }
            }
        }else{
            $abilityId = $brand->post()->where('status' , 1)->pluck('id')->toArray();
        }

        if ($request->allSize){
            $allSize = explode(',' , $request->allSize);
            $sizeId = [];
            for ( $i = 0; $i < count($post); $i++) {
                $sizeIds = json_decode($post[$i]['review'][0]['size'] , true);
                if ($sizeIds != null){
                    for ( $i2 = 0; $i2 < count($sizeIds); $i2++) {
                        for ( $i3 = 0; $i3 < count($allSize); $i3++) {
                            if ($allSize[$i3] == $sizeIds[$i2]['name']){
                                array_push($sizeId , $post[$i]['id']);
                            }
                        }
                    }
                }
            }
        }else{
            $sizeId = $brand->post()->where('status' , 1)->pluck('id')->toArray();
        }

        if ($request->search){
            $searchId = $brand->post()->latest()->where("title" , "LIKE" , "%{$request->search}%")->where('status' , 1)->pluck('id')->toArray();
        }else{
            $searchId = $brand->post()->where('status' , 1)->pluck('id')->toArray();
        }

        if ($request->allColor){
            $allColor = explode(',' , $request->allColor);
            $colorId = [];
            for ( $i = 0; $i < count($post); $i++) {
                $colorIds = json_decode($post[$i]['review'][0]['colors'] , true);
                if ($colorIds != null){
                    for ( $i2 = 0; $i2 < count($colorIds); $i2++) {
                        for ( $i3 = 0; $i3 < count($allColor); $i3++) {
                            if ($allColor[$i3] == $colorIds[$i2]['name']){
                                array_push($colorId , $post[$i]['id']);
                            }
                        }
                    }
                }
            }
        }else{
            $colorId = $brand->post()->where('status' , 1)->pluck('id')->toArray();
        }
        if ($request->max){
            $rangeId = $brand->post()->where('price', '>=', $request->min)->where('status' , 1)->where('price', '<=', $request->max)->pluck('id')->toArray();
        }else{
            $rangeId = $brand->post()->where('status' , 1)->pluck('id')->toArray();
        }

        if ($request->suggest){
            $suggestId = $brand->post()->where('suggest' , '!=' , null)->where('status' , 1)->pluck('id')->toArray();
        }else{
            $suggestId = $brand->post()->where('status' , 1)->pluck('id')->toArray();
        }

        if ($request->count){
            $countId = $brand->post()->where('count' , '!=' , '0')->where('status' , 1)->pluck('id')->toArray();
        }else{
            $countId = $brand->post()->where('status' , 1)->pluck('id')->toArray();
        }

        if ($request->allBrands){
            $brandId1 = [];
            $brandId = [];
            for ( $i = 0; $i < count($request->allBrands); $i++) {
                $brandCheck1 = Brand::where('name', $request->allBrands[$i])->first();
                $brandCheck = $brandCheck1->post()->pluck('id');
                array_push($brandId1 , $brandCheck);
            }
            for ( $i = 0; $i < count($brandId1[0]); $i++) {
                $send = Post::where('id' , $brandId1[0][$i])->pluck('id')->first();
                array_push($brandId , $send);
            }
        }else{
            $brandId = $brand->post()->where('status' , 1)->pluck('id')->toArray();
        }

        $arrayFilter = array_intersect($brandId, $rangeId,$colorId,$searchId,$countId,$suggestId,$sizeId,$abilityId);

        $showPostPage = Setting::where('key' , 'showPostPage')->pluck('value')->first();

        if ($request->show == 0){
            $catPost = $brand->post()->where('variety' , 0)->latest()->whereIn('id' , $arrayFilter)->where('status' , 1)->with('review')->paginate($showPostPage);
        }
        if ($request->show == 2){
            $catPost = $brand->post()->where('variety' , 0)->withCount('payMeta')->orderBy('pay_meta_count','DESC' )->whereIn('id' , $arrayFilter)->where('status' , 1)->with('review')->paginate($showPostPage);
        }
        if ($request->show == 1 or $request->show == 3){
            $catPost = $brand->post()->where('variety' , 0)->withCount('view')->orderBy('view_count','DESC' )->whereIn('id' , $arrayFilter)->where('status' , 1)->with('review')->paginate($showPostPage);
        }
        if ($request->show == 4){
            $catPost = $brand->post()->where('variety' , 0)->orderBy('price')->whereIn('id' , $arrayFilter)->where('status' , 1)->with('review')->paginate($showPostPage);
        }
        if ($request->show == 5){
            $catPost = $brand->post()->where('variety' , 0)->orderBy('price','DESC')->whereIn('id' , $arrayFilter)->where('status' , 1)->with('review')->paginate($showPostPage);
        }
        return $catPost;
    }

    public function searchNav(Request $request){
        $product = Post::where("title" , "LIKE" , "%{$request->search}%")->where('variety' , 0)->where('status' , 1)->take(10)->get();
        if(count($product) == 0){
            $product = Post::where("product_id" , "LIKE" , "%{$request->search}%")->where('variety' , 0)->where('status' , 1)->take(10)->get();
        }
        return $product;
    }

    public function blog(){
        $name = 'تمامی خبر ها';
        $title = Setting::where('key' , 'title')->pluck('value')->first();
        $logo = Setting::where('key' , 'logo')->pluck('value')->first() ?:'' ;
        $shortActivity = Setting::where('key' , 'descriptionSeo')->pluck('value')->first() ?:'' ;
        $this->seoSingleSeo(   'تمامی خبر ها' . " - $title " , $shortActivity , 'store' , 'blog' , $logo );
        $cats = collect(['slug' => 'blog' ,'name' => $name]);
        $urlpages = '/change/blog';
        return view('home.archive.news', compact('cats','name','urlpages'));
    }
    public function blogChange(){
        return News::latest()->paginate(20);
    }
    public function categoryBlog(Category $CategoryNewsSlug){
        $category = $CategoryNewsSlug;
        $name = Category::where('id' , $category->id)->pluck('name')->first();
        $title = Setting::where('key' , 'title')->pluck('value')->first();
        $logo = Setting::where('key' , 'logo')->pluck('value')->first() ?:'' ;
        $shortActivity = Setting::where('key' , 'descriptionSeo')->pluck('value')->first() ?:'' ;
        $this->seoSingleSeo(   $category->name . " - $title " , $shortActivity , 'store' , 'blog/category'."$category->slug" , $logo );
        $cats = collect(['slug' => $category->slug ,'name' => $name]);
        $urlpages = '/change/blog/category/'.$category->slug;
        return view('home.archive.news', compact('cats','name','urlpages'));
    }
    public function categoryBlogChange(Category $CategoryNewsSlug){
        $category = $CategoryNewsSlug;
        return $category->news()->latest()->paginate(20);
    }
}
