<?php

namespace App\Http\Controllers\Home;

use App\Http\Controllers\Controller;
use App\Models\Carrier;
use App\Models\Cart;
use App\Models\Discount;
use App\Models\Event;
use App\Models\Post;
use App\Models\Setting;
use App\Models\Time;
use Carbon\Carbon;
use Hekmatinasser\Verta\Verta;
use Illuminate\Http\Request;
use Illuminate\Http\Response;

class CartController extends Controller
{
    public function checkDiscount(Request $request){
        $time = Carbon::now()->format('Y-m-d h:i');
        $dis = Discount::where('code' , $request->discount)->where('status' , 1)->where('count' , '>=' , 1)->first();
        if($dis){
            if($dis['date']){
                $dis = Discount::where('code' , $request->discount)->where('status' , 1)->where('day', '>=' , $time)->where('count' , '>=' , 1)->first();
            }
            $carts = auth()->user()->cart;
            if($dis->post_id){
                $ss = Cart::where('post_id',$dis->post_id)->where('user_id' , auth()->user()->id)->first();
                if(!$ss){
                    $dis = '';
                }
            }
            if($dis){
                foreach ($carts as $value) {
                    $value->update([
                        'discount' => $dis['code']
                    ]);
                }
                $Amount = 0;
                for ( $i = 0; $i < count($carts); $i++) {
                    $allSum2 = (int)$carts[$i]['price'] * (int)$carts[$i]['count'];
                    $Amount = $Amount + (int)$allSum2;
                    if($dis->post_id){
                        if($carts[$i]['post_id'] == $dis['post_id']){
                            $Amount = $Amount - ((($carts[$i]['price']*$carts[$i]['count']) * $dis->percent) / 100);
                        }
                    }else{
                        $Amount = $Amount - (($Amount * $dis->percent) / 100);
                    }
                }
                return $Amount;
            }

        }
        return 2;
    }

    public function cart(){
        if (auth()->user()) {
            $count = Cart::where('post_id','!=',0)->where('user_id' , auth()->user()->id)->get();
            for ($i = 0; $i < count($count); $i++) {
                $countCheck = Post::where('id', $count[$i]->post_id)->pluck('count')->first();
                $post = Post::where('id', $count[$i]->post_id)->with('review')->first();
                $postSize = [];
                $postColor = [];
                $price = $post->price;
                if ($count[$i]['colorN']){
                    $cartColor = json_decode($count[$i]['color'],true)['name'];
                    foreach (json_decode($post['review'][0]['colors'] , true) as $item) {
                        if($item['name'] == $cartColor){
                            $postColor = $item;
                            $price = $price + $postColor['price'];
                            $count[$i]->update([
                                'color' => json_encode($postColor),
                            ]);
                            if($postColor['count'] <=0 || $item['count'] < $count[$i]['count']){
                                $count[$i]->update([
                                    'color' => 'empty',
                                ]);
                            }
                        }
                    }
                }
                if ($count[$i]['sizeN']){
                    $cartSize = $count[$i]['size'];
                    foreach (json_decode($post['review'][0]['size'] , true) as $item) {
                        if($item['name'] == $cartSize){
                            $postSize = $item;
                            $price = $price + $postSize['price'];
                            $count[$i]->update([
                                'size' => json_encode($postSize),
                            ]);
                            if($postSize['count'] <=0 || $item['count'] < $count[$i]['count']){
                                $count[$i]->update([
                                    'size' => 'empty',
                                ]);
                            }
                        }
                    }
                }
                $count[$i]->update([
                    'price' => $price,
                ]);
                if ($countCheck - $count[$i]->count < 0 || $count[$i]['size'] == 'empty' || $count[$i]['color'] == 'empty') {
                    $count[$i]->delete();
                }
            };
        }
        return view('home.cart.cart');
    }
    public function changeCarrier(Request $request){
        foreach (auth()->user()->cart as $value) {
            $value->carrier()->detach();
            $value->carrier()->sync($request->carrier);
        }
    }
    public function changeTimeDelivery(Request $request){
        foreach (auth()->user()->cart as $value) {
            $value->update([
                'delivery' => $request->time
            ]);
        }
    }
    public function cartAddress(){
        if (auth()->user()) {
            $count = Cart::where('post_id','!=',0)->where('user_id' , auth()->user()->id)->get();
            for ($i = 0; $i < count($count); $i++) {
                $countCheck = Post::where('id', $count[$i]->post_id)->pluck('count')->first();
                $post = Post::where('id', $count[$i]->post_id)->with('review')->first();
                $postSize = [];
                $postColor = [];
                $price = $post->price;
                if ($count[$i]['colorN']){
                    $cartColor = json_decode($count[$i]['color'],true)['name'];
                    foreach (json_decode($post['review'][0]['colors'] , true) as $item) {
                        if($item['name'] == $cartColor){
                            $postColor = $item;
                            $price = $price + $postColor['price'];
                            $count[$i]->update([
                                'color' => json_encode($postColor),
                            ]);
                            if($postColor['count'] <=0){
                                $count[$i]->update([
                                    'color' => 'empty',
                                ]);
                            }
                        }
                    }
                    if ($postColor == []){
                        $count[$i]->update([
                            'color' => 'empty',
                        ]);
                    }
                }
                if ($count[$i]['sizeN']){
                    $cartSize = json_decode($count[$i]['size'],true)['name'];
                    foreach (json_decode($post['review'][0]['size'] , true) as $item) {
                        if($item['name'] == $cartSize){
                            $postSize = $item;
                            $price = $price + $postSize['price'];
                            $count[$i]->update([
                                'size' => json_encode($postSize),
                            ]);
                            if($postSize['count'] <= 0){
                                $count[$i]->update([
                                    'size' => 'empty',
                                ]);
                            }
                        }
                    }
                    if ($postSize == []){
                        $count[$i]->update([
                            'size' => 'empty',
                        ]);
                    }
                }
                $count[$i]->update([
                    'price' => $price,
                ]);
                if ($countCheck - $count[$i]->count < 0 || $count[$i]['size'] == 'empty' || $count[$i]['color'] == 'empty') {
                    $count[$i]->delete();
                }
            };
            if($count){
                $cart = auth()->user()->cart()->pluck('post_id');
                $posts = Post::whereIn('id', $cart)->with('time')->get();
                $ids = [];
                foreach ($posts as $item){
                    if(count($item['time']) >= 1){
                        $id = $item['time'][0]['id'];
                        array_push($ids , $id);
                    }
                }
                $times = Time::whereIn('id' , $ids)->orderBy('day','DESC' )->first();
                $days = [];
                if ($times){
                    for ( $i = $times['day'] - 1; $i < $times['day']+5; $i++) {
                        $v = new Verta('+'.++$i . "day");
                        $day = Carbon::instance($v)->format('l');
                        --$i;
                        $date = [
                            'dayL'=> '',
                            'dayLEn'=> $day,
                            'price'=> 0,
                            'to'=> $times['to'],
                            'from'=> $times['from'],
                            'day'=> $v->day,
                            'month'=> $v->format('%B'),
                            'timestamp'=> Carbon::now()->addDays($i)->timestamp,
                        ];
                        if($day == 'Saturday'){
                            $date['dayL'] = 'چهار شنبه';
                        }
                        if($day == 'Sunday'){
                            $date['dayL'] = 'پنجشنبه';
                        }
                        if($day == 'Monday'){
                            $date['dayL'] = 'جمعه';
                        }
                        if($day == 'Tuesday'){
                            $date['dayL'] = 'شنبه';
                        }
                        if($day == 'Wednesday'){
                            $date['dayL'] = 'یکشنبه';
                        }
                        if($day == 'Thursday'){
                            $date['dayL'] = 'دوشنبه';
                        }
                        if($day == 'Friday'){
                            $date['dayL'] = 'سه شنبه';
                        }
                        array_push($days , $date);
                    }
                }
                $carriers = Carrier::latest()->get();
                if(count($count) >= 1){
                    if(!$count[0]->carrier){
                        foreach ($count as $item){
                            $item->carrier()->sync($carriers[0]['id']);
                        }
                    }
                }
                $map = Setting::where('key' , 'map')->pluck('value')->first();
                return view('home.cart.address' , compact('carriers','map','days'));
            }else{
                return redirect('/');
            }
        }else{
            return redirect('/login');
        }
    }

    public function addCart2(Request $request)
    {
        if($request->sizeName){
            $sizeN = $request->sizeName['name'];
        }else{
            $sizeN = '';
        }
        if($request->colorName){
            $colorN = $request->colorName['name'];
        }else{
            $colorN = '';
        }
        if (auth()->user()) {
            $myCart = $request->cookie('myCart');
            $cart = Cart::where('post_id', $request->postID)->where('guarantee_id', $request->guarantee)->where('sizeN', $sizeN)->where('colorN', $colorN)->where('user_id', auth()->user()->id)->get();
            if (count($cart) >= 1) {
                $countCheck = Post::where('id', $cart[0]->post_id)->pluck('count')->first();
                $cartCount = 0;
                for ($i = 0; $i < count($cart); $i++) {
                    $cartCount = $cartCount + $cart[$i]->count;
                }
            } else {
                $countCheck = 100;
                $cartCount = 0;
            }
            if ($countCheck - $cartCount >= 1) {
                $check = Cart::where('post_id', $request->postID)->where('sizeN', $sizeN)->where('colorN', $colorN)->where('guarantee_id', $request->guarantee)->where('user_id', auth()->user()->id)->where('guarantee_id', $request->guarantee)->first();
                if ($check) {
                    $check->update([
                        'count' => ++$check->count
                    ]);
                    $changeCart = [];
                    foreach(json_decode($myCart , true) as $item) {
                        if ($item['id'] == $request->postID && $sizeN == $item['sizeN'] && $colorN == $item['colorN'] && $request->guarantee == $item['guarantee_id']) {
                            $count = ++$item['count'];
                            $cartItem = [
                                'id' => $item['id'],
                                'count' => $count,
                                'color' => $item['color'],
                                'size' => $item['size'],
                                'colorN' => $item['colorN'],
                                'sizeN' => $item['sizeN'],
                                'price' => $item['price'],
                                'guarantee_id' => $item['guarantee_id'],
                            ];
                            array_push($changeCart, $cartItem);
                        }else{
                            array_push($changeCart, $item);
                        }
                    }
                    $response = new Response('Hello World');
                    return $response->withCookie(cookie('myCart', json_encode($changeCart), 500));
                } else {
                    Cart::create([
                        'post_id' => $request->postID,
                        'user_id' => auth()->user()->id,
                        'guarantee_id' => $request->guarantee,
                        'color' => json_encode($request->colorName),
                        'size' => json_encode($request->sizeName),
                        'colorN' => $colorN,
                        'sizeN' => $sizeN,
                        'price' => $request->price,
                        'count' => 1,
                    ]);
                    $post = Post::where('id', $request->postID)->pluck('title')->first();
                    Event::create([
                        'type' => 3,
                        'title' => 'سبد خرید',
                        'user_id' => auth()->user()->id,
                        'description' => 'کاربر با نام ' . auth()->user()->name . ' محصول ' . $post . ' را به سبد خرید اضافه کرد',
                    ]);
                    $changeCart = [];
                    foreach(json_decode($myCart , true) as $item) {
                        if ($item['id'] == $request->postID && json_encode($request->sizeName) == $item['size'] && json_encode($request->colorName) == $item['color'] && $request->guarantee == $item['guarantee_id']) {
                            $count = ++$item['count'];
                            $cartItem = [
                                'id' => $item['id'],
                                'count' => $count,
                                'color' => $item['color'],
                                'colorN' => $item['colorN'],
                                'price' => $item['price'],
                                'size' => $item['size'],
                                'sizeN' => $item['sizeN'],
                                'guarantee_id' => $item['guarantee_id'],
                            ];
                            array_push($changeCart, $cartItem);
                        }else{
                            array_push($changeCart, $item);
                        }
                    }
                    $c = collect($changeCart);
                    $filtered = $c->where('id', '=' , $request->postID)->where('size', '=' , $sizeN)->where('color', '=' , $colorN)->where('guarantee_id', '=' , $request->guarantee)->first();
                    if(!$filtered){
                        $cart=[
                            'id' => $request->postID,
                            'count' => 1,
                            'color' => json_encode($request->colorName),
                            'size' => json_encode($request->sizeName),
                            'colorN' => $colorN,
                            'sizeN' => $sizeN,
                            'guarantee_id' => $request->guarantee,
                            'price' => $request->price,
                        ];
                        array_push($changeCart, $cart);
                    }
                    $response = new Response('success');
                    return $response->withCookie(cookie('myCart', json_encode($changeCart), 500));
                }
            } else {
                return 'limit';
            }
        } else {
            $myCart = $request->cookie('myCart');
            if(!empty($myCart)){
                if ($myCart){
                    $changeCart = [];
                    foreach(json_decode($myCart , true) as $item) {
                        if ($item['id'] == $request->postID && $sizeN == $item['sizeN'] && $colorN == $item['colorN'] && $request->guarantee == $item['guarantee_id']) {
                            $count = ++$item['count'];
                            $cartItem = [
                                'id' => $item['id'],
                                'count' => $count,
                                'price' => $item['price'],
                                'color' => $item['color'],
                                'size' => $item['size'],
                                'colorN' => $item['colorN'],
                                'sizeN' => $item['sizeN'],
                                'guarantee_id' => $item['guarantee_id'],
                            ];
                            array_push($changeCart, $cartItem);
                        } else {
                            array_push($changeCart, $item);
                        }
                    }
                    $c = collect($changeCart);
                    $filtered = $c->where('id', '=' , $request->postID)->where('sizeN', '=' , $sizeN)->where('colorN', '=' , $colorN)->where('guarantee_id', '=' , $request->guarantee)->first();
                    if(!$filtered){
                        $cart=[
                            'id' => $request->postID,
                            'count' => 1,
                            'color' => json_encode($request->colorName),
                            'size' => json_encode($request->sizeName),
                            'colorN' => $colorN,
                            'sizeN' => $sizeN,
                            'guarantee_id' => $request->guarantee,
                            'price' => $request->price,
                        ];
                        array_push($changeCart, $cart);
                    }
                    $response = new Response('success');
                    return $response->withCookie(cookie('myCart', json_encode($changeCart), 500));
                }else{
                    $cart=[
                        'id' => $request->postID,
                        'count' => 1,
                        'color' => json_encode($request->colorName),
                        'size' => json_encode($request->sizeName),
                        'colorN' => $colorN,
                        'sizeN' => $sizeN,
                        'guarantee_id' => $request->guarantee,
                        'price' => $request->price,
                    ];
                    $response = new Response('success');
                    return $response->withCookie(cookie('myCart', json_encode([$cart]) , 500));
                }
            }else{
                $cart=[
                    'id' => $request->postID,
                    'count' => 1,
                    'color' => json_encode($request->colorName),
                    'size' => json_encode($request->sizeName),
                    'colorN' => $colorN,
                    'sizeN' => $sizeN,
                    'guarantee_id' => $request->guarantee,
                    'price' => $request->price,
                ];
                $response = new Response('success');
                return $response->withCookie(cookie('myCart', json_encode([$cart]) , 500));
            }
        }
    }

    public function getCarts()
    {
        $types = [];
        if (auth()->user()) {
            $count = Cart::where('user_id' , auth()->user()->id)->with('guarantee','carrier','user')->get();
            $carts = [];
            foreach ($count as $item) {
                if($item->post_id){
                    $send = Post::where('id', $item->post_id)->with('user')->first();
                    $type = 0;
                }else{
                    $send = Post::first();
                    $type = 1;
                }
                array_push($carts, $send);
                array_push($types, $type);
            };
        } else {
            $value = request()->cookie('myCart');
            $count = json_decode($value,true);
            $cart = collect(json_decode($value , true))->pluck('id');
            $carts = [];
            foreach ($cart as $item) {
                if($item){
                    $send = Post::where('id', $item)->with('user')->first();
                    $type = 0;
                }else{
                    $send = Post::first();
                    $type = 1;
                }
                array_push($carts, $send);
                array_push($types, $type);
            };
        }
        return [$carts, $count,$types];
    }

    public function changeCart(Request $request)
    {
        if($request->size){
            $size = $request->size;
        }else{
            $size = '';
        }
        if($request->color){
            $color = $request->color;
        }else{
            $color = '';
        }
        $post = Post::where('id', $request->product)->pluck('count')->first();
        if ($request->change == 0) {
            if(auth()->user()){
                $cart = Cart::where('post_id', $request->product)->where('sizeN', $size)->where('colorN', $color)->where('guarantee_id', $request->guarantee)->where('user_id', auth()->user()->id)->first();
                if ($cart->count == 1) {
                    $cart->delete();
                } else {
                    $cart->update([
                        'count' => --$cart->count
                    ]);
                }
            }
            $myCart = request()->cookie('myCart');
            if(!empty($myCart)){
                if ($myCart){
                    $changeCart = [];
                    foreach(json_decode($myCart , true) as $item) {
                        if ($item['id'] == $request->product && $size == $item['sizeN'] && $color == $item['colorN'] && $request->guarantee == $item['guarantee_id']) {
                            if ($item['count'] == 1) {
                            } else {
                                $count = --$item['count'];
                                $cartItem = [
                                    'id' => $item['id'],
                                    'count' => $count,
                                    'price' => $item['price'],
                                    'color' => $item['color'],
                                    'size' => $item['size'],
                                    'colorN' => $item['colorN'],
                                    'sizeN' => $item['sizeN'],
                                    'guarantee_id' => $item['guarantee_id'],
                                ];
                                array_push($changeCart, $cartItem);
                            }
                        } else {
                            array_push($changeCart, $item);
                        }
                    }
                    $c = collect($changeCart);
                    $response = new Response('success');
                    return $response->withCookie(cookie('myCart', json_encode($changeCart), 500));
                }
            }
        } else {
            if(auth()->user()){
                $cart = Cart::where('post_id', $request->product)->where('sizeN', $size)->where('colorN', $color)->where('guarantee_id', $request->guarantee)->where('user_id', auth()->user()->id)->first();
                if ($post - $cart->count >= 1) {
                    $cart->update([
                        'count' => ++$cart->count
                    ]);
                    return 'success';
                } else {
                    return 'limit';
                }
            }
            $myCart = request()->cookie('myCart');
            if(!empty($myCart)){
                if ($myCart){
                    $changeCart = [];
                    foreach(json_decode($myCart , true) as $item) {
                        if ($item['id'] == $request->product && $size == $item['sizeN'] && $color == $item['colorN'] && $request->guarantee == $item['guarantee_id']) {
                            if ($post - $item['count'] >= 1) {
                                $count = ++$item['count'];
                            } else {
                                $count = $item['count'];
                            }
                            $cartItem = [
                                'id' => $item['id'],
                                'count' => $count,
                                'price' => $item['price'],
                                'color' => $item['color'],
                                'size' => $item['size'],
                                'colorN' => $item['colorN'],
                                'sizeN' => $item['sizeN'],
                                'guarantee_id' => $item['guarantee_id'],
                            ];
                            array_push($changeCart, $cartItem);
                        } else {
                            array_push($changeCart, $item);
                        }
                    }
                    $c = collect($changeCart);
                    $response = new Response('success');
                    return $response->withCookie(cookie('myCart', json_encode($changeCart), 500));
                }
            }
        }
    }

    public function deleteCart(Request $request)
    {
        if($request->size){
            $size = $request->size;
        }else{
            $size = '';
        }
        if($request->color){
            $color = $request->color;
        }else{
            $color = '';
        }
        if(auth()->user()){
            if($request->product == 0){
                $cart = Cart::where('guarantee_id', $request->guarantee)->where('user_id', auth()->user()->id)->first();
            }else{
                $cart = Cart::where('post_id', $request->product)->where('sizeN' ,$size)->where('colorN', $color)->where('guarantee_id', $request->guarantee)->where('user_id', auth()->user()->id)->first();
            }
            if($cart){
                $cart->delete();
            }
        }
        $myCart = request()->cookie('myCart');
        if(!empty($myCart)){
            if ($myCart){
                $changeCart = [];
                foreach(json_decode($myCart , true) as $item) {
                    if($request->product == 0){
                        if ($request->guarantee == $item['guarantee_id']) {

                        } else {
                            array_push($changeCart, $item);
                        }
                    }else{
                        if ($item['id'] == $request->product && $size == $item['sizeN'] && $color == $item['colorN'] && $request->guarantee == $item['guarantee_id']) {

                        } else {
                            array_push($changeCart, $item);
                        }
                    }
                }
                $c = collect($changeCart);
                $response = new Response('success');
                return $response->withCookie(cookie('myCart', json_encode($changeCart), 500));
            }
        }
    }
}
