<?php

namespace App\Http\Middleware;

use Carbon\Carbon;
use Closure;
use Hekmatinasser\Verta\Verta;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\DB;

class LastUserActivity
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle(Request $request, Closure $next)
    {
        if (Auth::check()) {
            $cart = auth()->user()->cart;
            if (count($cart) >= 1){
                if ($cart[0]['delivery']){
                    $carts = json_decode($cart[0]['delivery'],true)['timestamp'];
                    $v = Carbon::now();
                    $v1 = $v->timestamp;
                    if ($v1>= $carts) {
                        DB::table('carts')->whereIn('id', auth()->user()->cart()->pluck('id'))->update(['delivery'=> null]);
                    }
                }
            }
        }
        $value = request()->cookie('myCart');
        if(empty($value)) {
            return $next($request)->withCookie(cookie('myCart', json_encode([]), 500));
        }else{
            return $next($request);
        }
    }
}
