<?php

namespace App\Providers;

use App\Models\Cart;
use App\Models\Category;
use App\Models\Link;
use App\Models\Page;
use App\Models\Post;
use App\Models\Setting;
use App\Models\Ticket;
use App\Models\Pay;
use App\Models\User;
use App\Models\Comment;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\ServiceProvider;
use Inertia\Inertia;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        Inertia::share('appName', config('app.name'));

// Lazily
        Inertia::share('errors', function(){
            return session()->get('errors') ? session()->get('errors')->getBag('default')->getMessages() : (object) [];
        });
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */

    public function boot()
    {
        Inertia::share('appName', config('app.name'));

        Inertia::share('allow', fn (Request $request) => $request->user()
            ? $request->user()->getAllPermissions()
            : null
        );
        Inertia::share('userData', fn (Request $request) => $request->user()
            ? $request->user()
            : null
        );
        Inertia::share('ticketSeen', fn (Request $request) => Ticket::where('seen' , 0)->get()
            ? Ticket::where('seen' , 0)->count()
            : null
        );
        Inertia::share('userSeen', fn (Request $request) => User::where('seen' , 0)->get()
            ? User::where('seen' , 0)->count()
            : null
        );
        Inertia::share('commentSeen', fn (Request $request) => Comment::where('seen' , 0)->get()
            ? Comment::where('seen' , 0)->count()
            : null
        );
        Inertia::share('paySeen', fn (Request $request) => Pay::where('seen' , 0)->get()
            ? count(Pay::where('seen' , 0)->get())
            : null
        );
        Inertia::share('logo', fn (Request $request) => Setting::where('key' , 'logo')->pluck('value')->first()
            ? Setting::where('key' , 'logo')->pluck('value')->first()
            : null
        );
        view()->composer('home.master', function ($view) {
            $user = auth()->user();
            $logo = Setting::where('key' , 'logo')->pluck('value')->first();

            $catHeader1 = Setting::where('key' , 'catHeader')->pluck('value')->first();
            $cats = [];
            if ($catHeader1 != null){
                $allCatHeader1 = explode('[' , $catHeader1);
                $allCatHeader2 = explode(']' , $allCatHeader1[1]);
                $allCatHeader3 = explode(',' , $allCatHeader2[0]);
                foreach ($allCatHeader3 as $item){
                    $send = Category::where('id' , $item)->with(["cats" => function($q){
                        $q->latest()->with(["cats" => function($q){
                            $q->latest()->with(["cats" => function($q){
                                $q->latest()->with('cats');}]);}]);}])->first();
                    if($send){
                        array_push($cats ,$send);
                    }
                }
            }

            $siteTelegram = Setting::where('key' , 'telegram')->pluck('value')->first();
            $siteTwitter = Setting::where('key' , 'twitter')->pluck('value')->first();
            $siteInstagram = Setting::where('key' , 'instagram')->pluck('value')->first();
            $siteFacebook = Setting::where('key' , 'facebook')->pluck('value')->first();
            $pages = Page::latest()->get();
            if ($user){
                $users = $user;
            }else{
                $users = 0;
            }

            $catFooter1 = Setting::where('key' , 'catFooter')->pluck('value')->first();
            $footercat = [];
            if ($catFooter1 != null){
                $allFooter1 = explode('[' , $catFooter1);
                $allFooter2 = explode(']' , $allFooter1[1]);
                $allFooter3 = explode(',' , $allFooter2[0]);
                foreach ($allFooter3 as $item){
                    $send = Category::where('id' , $item)->with(["cats" => function($q){
                        $q->latest()->with(["cats" => function($q){
                            $q->latest()->with(["cats" => function($q){
                                $q->latest()->with('cats');}]);}]);}])->first();
                    if($send){
                        array_push($footercat ,$send);
                    }
                }
            }
            $name = Setting::where('key' , 'name')->pluck('value')->first();
            $title = Setting::where('key' , 'title')->pluck('value')->first();
            $about = Setting::where('key' , 'about')->pluck('value')->first();
            $number = Setting::where('key' , 'number')->pluck('value')->first();
            $enamad = Setting::where('key' , 'etemad')->pluck('value')->first();
            $fanavari = Setting::where('key' , 'fanavari')->pluck('value')->first();
            $links = Link::latest()->get();
            $off = Post::where('status' , 1)->orderBy('off','DESC')->take(3)->select(['title','slug'])->get();
            $post1 = request()->segment(count(request()->segments()));
            $post2 = Post::where('slug' , $post1)->first();
            if($post2){
                $post= $post2;
            }else{
                $post = '';
            }
            $view->with([
                'user' =>$users,
                'title' =>$title,
                'enamad' =>$enamad,
                'fanavari' =>$fanavari,
                'logo' =>$logo,
                'post' =>$post,
                'cats' =>$cats,
                'links' =>$links,
                'off' =>$off,
                'pages' =>$pages,
                'telegram' =>$siteTelegram,
                'twitter' =>$siteTwitter,
                'instagram' =>$siteInstagram,
                'facebook' =>$siteFacebook,
                'footercat' =>$footercat,
                'name' =>$name,
                'about' =>$about,
                'number' =>$number,
            ]);
        });
    }
}
