<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Ask;
use App\Models\Page;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Inertia\Inertia;

class AskController extends Controller
{
    public function index(Request $request){
        $edits = 1;
        $deletes = 1;
        $adds = 1;
        $shows = 1;

        if($request->value){
            DB::table('asks')->whereIn('id', $request->value)->delete();
        }
        if($request->name){
            $request->validate([
                'name' => 'required|max:220',
            ]);
            if($request->taxId){
                $tax = Ask::where('id' , $request->taxId)->first();
                $tax->update([
                    'name'=> $request->name,
                    'body'=> $request->body,
                    'updated_at'=> Carbon::now(),
                ]);
            }else{
                $tax = Ask::where('name' , $request->name)->first();
                if (!$tax){
                    $tax = Ask::create([
                        'name'=> $request->name,
                        'body'=> $request->body,
                    ]);
                }
            }
        }
        if($request->taxId && !$request->name){
            $taxEdit = Ask::where('id' , $request->taxId)->first();
        }else{
            $taxEdit = '';
        }

        if ($request->search){
            $search = Ask::where("name" , "LIKE" , "%{$request->search}%")->pluck('id')->toArray();
            if(count($search) == 0){
                $search = Ask::where("id" , "LIKE" , "%{$request->search}%")->pluck('id')->toArray();
            }
        }else{
            $search = Ask::latest()->pluck('id')->toArray();
        }
        if ($request->date){
            $date = Ask::whereDate('created_at',$request->date)->pluck('id')->toArray();
        }else{
            $date = Ask::latest()->pluck('id')->toArray();
        }

        $arrayFilter = array_intersect($search,$date);
        $taxes = Ask::latest()->whereIn('id' , $arrayFilter)->paginate(30);
        $name='سوالات متداول';
        $routeAddress='ask';
        $sidebar= '5';
        $labels = ['#','آیدی','تاریخ ثبت','عملیات'];
        return Inertia::render('Taxonami/AllTaxonami' , [
            'name' => $name,
            'labels' => $labels,
            'adds' => $adds,
            'shows' => $shows,
            'edits' => $edits,
            'deletes' => $deletes,
            'taxes' => $taxes,
            'taxEdit' => $taxEdit,
            'sidebar' => $sidebar,
            'routeAddress' => $routeAddress,
        ]);
    }
}
