<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Pay;
use App\Models\Comment;
use App\Models\Ticket;
use App\Models\Post;
use App\Models\User;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\DB;
use Hekmatinasser\Verta\Verta;
use App\Models\View;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use Inertia\Inertia;

class PanelController extends Controller
{
    public function index(){
        $users = User::get();
        foreach ($users as $user) {
            if (Cache::has('user-is-online-' . $user->id)){
                $user->update([
                    'activity' => Verta::now()->format('H:i Y-n-j')
                ]);
            }
        }

        $months = [];
        $monthPay = [];
        $monthView = [];
        for ( $i = 1; $i <= 13; $i++) {
            $monthNum = verta()->month($i)->format('Y/n/j');
            $monthEx = explode("/", $monthNum);
            $monthChange = Verta::getGregorian($monthEx[0], $monthEx[1], $monthEx[2]);
            $monthIm = implode("-", $monthChange)." 00:00:00";
            array_push($months , $monthIm);
        }
        for ( $i = 0; $i < 12; $i++) {
            if ($i != 12){
                $monthPays = Pay::where('status' , '100')->whereBetween('created_at', [$months[$i], $months[++$i]])->pluck('price')->sum();
                --$i;
                $monthViews = View::whereBetween('created_at', [$months[$i], $months[++$i]])->count();
                --$i;
            }else{
                $monthPays = Pay::where('status' , '100')->whereBetween('created_at', [$months[$i], $months[0]])->pluck('price')->sum();
                $monthViews = View::whereBetween('created_at', [$months[$i], $months[0]])->count();
            }
            array_push($monthPay , $monthPays);
            array_push($monthView , $monthViews);
        }
        $lastPost = Post::latest()->take(10)->get();

        $lastComment = Comment::latest()->with('post','user')->take(5)->get();
        $acceptComment = Comment::latest()->where('approved' , 1)->count();
        $checkComment = Comment::latest()->where('approved' , 0)->count();

        $lastUser = User::latest()->take(5)->get();
        $onlineUser = User::latest()->where('activity' , Verta::now()->format('H:i Y-n-j'))->count();
        $offUser = User::latest()->where('activity' , '!=' , Verta::now()->format('H:i Y-n-j'))->count();

        $startDayEn = verta()->startDay()->formatGregorian('Y-m-d H:i:s');
        $endDayEn = verta()->endDay()->formatGregorian('Y-m-d H:i:s');
        $startYesterdayEn = verta()->subDay(1)->startDay()->formatGregorian('Y-m-d H:i:s');
        $endYesterdayEn = verta()->subDay(1)->endDay()->formatGregorian('Y-m-d H:i:s');
        $startMonthEn = verta()->startMonth()->formatGregorian('Y-m-d H:i:s');
        $endMonthEn = verta()->endMonth()->formatGregorian('Y-m-d H:i:s');
        $startWeekEn = verta()->startWeek()->formatGregorian('Y-m-d H:i:s');
        $endWeekEn = verta()->endWeek()->formatGregorian('Y-m-d H:i:s');
        $startYearEn = verta()->startYear()->formatGregorian('Y-m-d H:i:s');
        $endYearEn = verta()->endYear()->formatGregorian('Y-m-d H:i:s');

        $viewDay = View::whereBetween('created_at', [$startDayEn, $endDayEn])->count();
        $viewYesterday = View::whereBetween('created_at', [$startYesterdayEn, $endYesterdayEn])->count();
        $viewMonth = View::whereBetween('created_at', [$startMonthEn, $endMonthEn])->count();
        $viewWeek = View::whereBetween('created_at', [$startWeekEn, $endWeekEn])->count();
        $viewYear = View::whereBetween('created_at', [$startYearEn, $endYearEn])->count();
        
        return Inertia::render('panel' , [
            'lastUser' => $lastUser,
            'onlineUser' => $onlineUser,
            'offUser' => $offUser,
            'monthPay' => $monthPay,
            'monthView' => $monthView,
            'acceptComment' => $acceptComment,
            'checkComment' => $checkComment,
            'lastPost' => $lastPost,
            'lastComment' => $lastComment,
            'viewDay' => $viewDay,
            'viewYesterday' => $viewYesterday,
            'viewMonth' => $viewMonth,
            'viewYear' => $viewYear,
            'viewWeek' => $viewWeek,
        ]);
    }
    public function logout(){
        Auth::logout();
        return redirect('/');
    }
}
