<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Brand;
use App\Models\Category;
use App\Models\Country;
use App\Models\Guarantee;
use App\Models\Report;
use App\Models\Setting;
use App\Models\Post;
use App\Models\Time;
use App\Models\User;
use App\Models\PayMeta;
use App\Models\Rate;
use App\Models\Review;
use App\Models\Tag;
use App\Traits\SendEmailTrait;
use App\Traits\SendSmsTrait;
use Illuminate\Support\Facades\Cache;
use Hekmatinasser\Verta\Verta;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Inertia\Inertia;

class PostController extends Controller
{
    use SendSmsTrait;
    use SendEmailTrait;
    public function index(Request $request){
        $showSome =  auth()->user()->getAllPermissions()->where('name' , 'نمایش کالا های خودش')->pluck('name');
        $showSome2 =  auth()->user()->getAllPermissions()->where('name' , 'نمایش همه کالا ها')->pluck('name');
        $checkEdits =  auth()->user()->getAllPermissions()->where('name' , 'ویرایش کالا')->pluck('name');
        $checkDeletes =  auth()->user()->getAllPermissions()->where('name' , 'حذف کالا')->pluck('name');
        if(auth()->user()->admin == 1 or count($checkEdits) >= 1){
            $edits = 1;
        }else{
            $edits = 0;
        }
        if(auth()->user()->admin == 1 or count($checkDeletes) >= 1){
            $deletes = 1;
        }else{
            $deletes = 0;
        }
        if(auth()->user()->admin == 1 or count($showSome) >= 1 or count($showSome2) >= 1){
            $shows = 1;
        }else{
            $shows = 0;
        }

        if($request->value){
            foreach ($request->value as $value) {
                $post = Post::where('id', $value)->first();
                if($post) {
                    $post->category()->detach();
                    $post->comments()->delete();
                    $post->like()->delete();
                    $post->brand()->detach();
                    $post->payMeta()->delete();
                    $post->cart()->delete();
                    $post->rate()->delete();
                    $post->report()->delete();
                    $post->question()->delete();
                    $post->review()->detach();
                    $post->guarantee()->detach();
                    $post->post()->update(array(
                        'variety' => 0,
                    ));
                    DB::table('bookmarks')->where('post_id', $post->id)->delete();
                    Review::where('id', $post->review()->pluck('id')->first())->delete();
                }
            }
            DB::table('posts')->whereIn('id', $request->value)->delete();
        }

        if($request->postShow){
            $showPosts = Post::where('id',$request->postShow)->where('variety',0)->with('user' , 'review')->withCount('comments','view')->first();
        }else{
            $showPosts = [];
        }

        if($request->postId){
            $request->validate([
                'title' => 'required|max:220',
                'image' => 'required',
                'status' => 'required',
                'count' => 'required|integer|digits_between: 1,5',
                'price' => 'required|integer|digits_between: 1,9',
            ]);
            $post = Post::where('id' , $request->postId)->where('variety',0)->first();
            if ($request->off){
                $price = round($request->price - $request->price * $request->off / 100);
            }else{
                $price = $request->price;
            }
            $post->update([
                'summery'=>$request->summery,
                'title'=>$request->title,
                'titleEn'=>$request->titleEn,
                'count'=>$request->count,
                'image'=>$request->image,
                'status'=>$request->status,
                'slug'=>$request->slug,
                'price'=>$price,
                'offPrice'=>$request->price,
                'off'=>$request->off,
                'suggest'=>$request->suggest,
            ]);
            $post->review()->first()->update([
                'body'=>$request->body,
                'titleEn'=>$request->titleEn,
            ]);
        }

        if($request->postEdit){
            $getPost = Post::where('id' , $request->postEdit)->where('variety',0)->with('review')->first();
        }else{
            $getPost = '';
        }
        if ($request->getPage){
            $page = $request->getPage;
        }else{
            $page = '25';
        }

        if ($request->category){
            if (count($showSome) >= 1){
                $categoryName = auth()->user()->category()->latest()->where('name' , $request->category)->first();
                $category = $categoryName->post()->with('category')->where('variety',0)->pluck('id')->toArray();
            }else{
                $categoryName = Category::latest()->where('name' , $request->category)->first();
                $category = $categoryName->post()->with('category')->where('variety',0)->pluck('id')->toArray();
            }
        }else{
            if (count($showSome) >= 1){
                $category = auth()->user()->post()->where('variety',0)->latest()->pluck('id')->toArray();
            }else{
                $category = Post::latest()->with('category')->withCount(["post" => function($q){
                    $q->where('status' ,1);
                }])->where('variety',0)->pluck('id')->toArray();
            }
        }

        $categories = Category::latest()->get();
        if ($request->sort == 1){
            if ($request->search){
                if ($request->date){
                    if (count($showSome) >= 1){
                        $posts = auth()->user()->post()->with('category')->withCount(["post" => function($q){
                            $q->where('status' ,1);
                        }])->where('variety',0)->latest()->where('status' , '0')->whereIn('id',$category)->whereDate('created_at',$request->date)->where("title" , "LIKE" , "%{$request->search}%")->paginate($page);
                    }else{
                        $posts = Post::latest()->with('category')->withCount(["post" => function($q){
                            $q->where('status' ,1);
                        }])->where('variety',0)->where('status' , '0')->whereIn('id',$category)->whereDate('created_at',$request->date)->where("title" , "LIKE" , "%{$request->search}%")->paginate($page);
                    }
                    if (count($posts) == 0){
                        if (count($showSome) >= 1){
                            $posts = auth()->user()->post()->with('category')->withCount(["post" => function($q){
                            $q->where('status' ,1);
                        }])->where('variety',0)->latest()->where('status' , '0')->whereIn('id',$category)->whereDate('created_at',$request->date)->where("id" , "LIKE" , "%{$request->search}%")->paginate($page);
                        }else{
                            $posts = Post::latest()->with('category')->withCount(["post" => function($q){
                            $q->where('status' ,1);
                        }])->where('variety',0)->where('status' , '0')->whereIn('id',$category)->whereDate('created_at',$request->date)->where("id" , "LIKE" , "%{$request->search}%")->paginate($page);
                        }
                    }
                }else{
                    if (count($showSome) >= 1){
                        $posts = auth()->user()->post()->with('category')->withCount(["post" => function($q){
                            $q->where('status' ,1);
                        }])->where('variety',0)->latest()->where('status' , '0')->whereIn('id',$category)->where("title" , "LIKE" , "%{$request->search}%")->paginate($page);
                    }else{
                        $posts = Post::latest()->with('category')->withCount(["post" => function($q){
                            $q->where('status' ,1);
                        }])->where('variety',0)->where('status' , '0')->whereIn('id',$category)->where("title" , "LIKE" , "%{$request->search}%")->paginate($page);
                    }
                    if (count($posts) == 0){
                        if (count($showSome) >= 1){
                            $posts = auth()->user()->post()->with('category')->withCount(["post" => function($q){
                            $q->where('status' ,1);
                        }])->where('variety',0)->latest()->where('status' , '0')->whereIn('id',$category)->where("id" , "LIKE" , "%{$request->search}%")->paginate($page);
                        }else{
                            $posts = Post::latest()->with('category')->withCount(["post" => function($q){
                            $q->where('status' ,1);
                        }])->where('variety',0)->where('status' , '0')->whereIn('id',$category)->where("id" , "LIKE" , "%{$request->search}%")->paginate($page);
                        }
                    }
                }
            }else{
                if ($request->date){
                    if (count($showSome) >= 1){
                        $posts = auth()->user()->post()->with('category')->withCount(["post" => function($q){
                            $q->where('status' ,1);
                        }])->where('variety',0)->latest()->whereDate('created_at',$request->date)->whereIn('id',$category)->where('status' , '0')->paginate($page);
                    }else{
                        $posts = Post::latest()->with('category')->withCount(["post" => function($q){
                            $q->where('status' ,1);
                        }])->where('variety',0)->whereDate('created_at',$request->date)->whereIn('id',$category)->where('status' , '0')->paginate($page);
                    }
                }else{
                    if (count($showSome) >= 1){
                        $posts = auth()->user()->post()->with('category')->withCount(["post" => function($q){
                            $q->where('status' ,1);
                        }])->where('variety',0)->latest()->where('status' , '0')->whereIn('id',$category)->paginate($page);
                    }else{
                        $posts = Post::latest()->with('category')->withCount(["post" => function($q){
                            $q->where('status' ,1);
                        }])->where('variety',0)->where('status' , '0')->whereIn('id',$category)->paginate($page);
                    }
                }
            }
        }elseif($request->sort == 2){
            if ($request->search){
                if ($request->date){
                    if (count($showSome) >= 1){
                        $posts = auth()->user()->post()->with('category')->withCount(["post" => function($q){
                            $q->where('status' ,1);
                        }])->where('variety',0)->latest()->where('status' , '1')->whereIn('id',$category)->whereDate('created_at',$request->date)->where("title" , "LIKE" , "%{$request->search}%")->paginate($page);
                    }else{
                        $posts = Post::latest()->with('category')->withCount(["post" => function($q){
                            $q->where('status' ,1);
                        }])->where('variety',0)->where('status' , '1')->whereIn('id',$category)->whereDate('created_at',$request->date)->where("title" , "LIKE" , "%{$request->search}%")->paginate($page);
                    }
                    if (count($posts) == 0){
                        if (count($showSome) >= 1){
                            $posts = auth()->user()->post()->with('category')->withCount(["post" => function($q){
                            $q->where('status' ,1);
                        }])->where('variety',0)->latest()->where('status' , '1')->whereIn('id',$category)->whereDate('created_at',$request->date)->where("id" , "LIKE" , "%{$request->search}%")->paginate($page);
                        }else{
                            $posts = Post::latest()->with('category')->withCount(["post" => function($q){
                            $q->where('status' ,1);
                        }])->where('variety',0)->where('status' , '1')->whereIn('id',$category)->whereDate('created_at',$request->date)->where("id" , "LIKE" , "%{$request->search}%")->paginate($page);
                        }
                    }
                }else{
                    if (count($showSome) >= 1){
                        $posts = auth()->user()->post()->with('category')->withCount(["post" => function($q){
                            $q->where('status' ,1);
                        }])->where('variety',0)->latest()->where('status' , '1')->whereIn('id',$category)->where("title" , "LIKE" , "%{$request->search}%")->paginate($page);
                    }else{
                        $posts = Post::latest()->with('category')->withCount(["post" => function($q){
                            $q->where('status' ,1);
                        }])->where('variety',0)->where('status' , '1')->whereIn('id',$category)->where("title" , "LIKE" , "%{$request->search}%")->paginate($page);
                    }
                    if (count($posts) == 0){
                        if (count($showSome) >= 1){
                            $posts = auth()->user()->post()->with('category')->withCount(["post" => function($q){
                            $q->where('status' ,1);
                        }])->where('variety',0)->latest()->where('status' , '1')->whereIn('id',$category)->where("id" , "LIKE" , "%{$request->search}%")->paginate($page);
                        }else{
                            $posts = Post::latest()->with('category')->withCount(["post" => function($q){
                            $q->where('status' ,1);
                        }])->where('variety',0)->where('status' , '1')->whereIn('id',$category)->where("id" , "LIKE" , "%{$request->search}%")->paginate($page);
                        }
                    }
                }
            }else{
                if ($request->date){
                    if (count($showSome) >= 1){
                        $posts = auth()->user()->post()->with('category')->withCount(["post" => function($q){
                            $q->where('status' ,1);
                        }])->where('variety',0)->latest()->whereDate('created_at',$request->date)->whereIn('id',$category)->where('status' , '1')->paginate($page);
                    }else{
                        $posts = Post::latest()->with('category')->withCount(["post" => function($q){
                            $q->where('status' ,1);
                        }])->where('variety',0)->whereDate('created_at',$request->date)->whereIn('id',$category)->where('status' , '1')->paginate($page);
                    }
                }else{
                    if (count($showSome) >= 1){
                        $posts = auth()->user()->post()->with('category')->withCount(["post" => function($q){
                            $q->where('status' ,1);
                        }])->where('variety',0)->latest()->where('status' , '1')->whereIn('id',$category)->paginate($page);
                    }else{
                        $posts = Post::latest()->with('category')->withCount(["post" => function($q){
                            $q->where('status' ,1);
                        }])->where('variety',0)->where('status' , '1')->whereIn('id',$category)->paginate($page);
                    }
                }
            }
        }else{
            if ($request->search){
                if ($request->date){
                    if (count($showSome) >= 1){
                        $posts = auth()->user()->post()->with('category')->withCount(["post" => function($q){
                            $q->where('status' ,1);
                        }])->where('variety',0)->latest()->whereIn('id',$category)->whereDate('created_at',$request->date)->where("title" , "LIKE" , "%{$request->search}%")->paginate($page);
                    }else{
                        $posts = Post::latest()->with('category')->withCount(["post" => function($q){
                            $q->where('status' ,1);
                        }])->where('variety',0)->whereIn('id',$category)->whereDate('created_at',$request->date)->where("title" , "LIKE" , "%{$request->search}%")->paginate($page);
                    }
                    if (count($posts) == 0){
                        if (count($showSome) >= 1){
                            $posts = auth()->user()->post()->with('category')->withCount(["post" => function($q){
                            $q->where('status' ,1);
                        }])->where('variety',0)->latest()->whereIn('id',$category)->whereDate('created_at',$request->date)->where("id" , "LIKE" , "%{$request->search}%")->paginate($page);
                        }else{
                            $posts = Post::latest()->with('category')->withCount(["post" => function($q){
                            $q->where('status' ,1);
                        }])->where('variety',0)->whereIn('id',$category)->whereDate('created_at',$request->date)->where("id" , "LIKE" , "%{$request->search}%")->paginate($page);
                        }
                    }
                }else{
                    if (count($showSome) >= 1){
                        $posts = auth()->user()->post()->with('category')->withCount(["post" => function($q){
                            $q->where('status' ,1);
                        }])->where('variety',0)->latest()->whereIn('id',$category)->where("title" , "LIKE" , "%{$request->search}%")->paginate($page);
                    }else{
                        $posts = Post::latest()->with('category')->withCount(["post" => function($q){
                            $q->where('status' ,1);
                        }])->where('variety',0)->whereIn('id',$category)->where("title" , "LIKE" , "%{$request->search}%")->paginate($page);
                    }
                    if (count($posts) == 0){
                        if (count($showSome) >= 1){
                            $posts = auth()->user()->post()->with('category')->withCount(["post" => function($q){
                            $q->where('status' ,1);
                        }])->where('variety',0)->latest()->whereIn('id',$category)->where("id" , "LIKE" , "%{$request->search}%")->paginate($page);
                        }else{
                            $posts = Post::latest()->with('category')->withCount(["post" => function($q){
                            $q->where('status' ,1);
                        }])->where('variety',0)->whereIn('id',$category)->where("id" , "LIKE" , "%{$request->search}%")->paginate($page);
                        }
                    }
                }
            }else{
                if ($request->date){
                    if (count($showSome) >= 1){
                        $posts = auth()->user()->post()->with('category')->withCount(["post" => function($q){
                            $q->where('status' ,1);
                        }])->where('variety',0)->latest()->whereIn('id',$category)->whereDate('created_at',$request->date)->paginate($page);
                    }else{
                        $posts = Post::latest()->with('category')->withCount(["post" => function($q){
                            $q->where('status' ,1);
                        }])->where('variety',0)->whereIn('id', $category)->whereDate('created_at',$request->date)->paginate($page);
                    }
                }else{
                    if (count($showSome) >= 1){
                        $posts = auth()->user()->post()->with('category')->withCount(["post" => function($q){
                            $q->where('status' ,1);
                        }])->where('variety',0)->latest()->whereIn('id', $category)->paginate($page);
                    }else{
                        $posts = Post::latest()->with('category')->withCount(["post" => function($q){
                            $q->where('status' ,1);
                        }])->where('variety',0)->whereIn('id',$category)->paginate($page);
                    }
                }
            }
        }
        $labels = ['آیدی','تصویر','عنوان','وضعیت','مبلغ','تاریخ ثبت','عملیات'];
        return Inertia::render('Post/AllPost' , [
            'labels' => $labels,
            'posts' => $posts,
            'getPost' => $getPost,
            'showPosts' => $showPosts,
            'edits' => $edits,
            'deletes' => $deletes,
            'shows' => $shows,
            'categories' => $categories,
        ]);
    }

    public function create(Request $request)
    {
        $productId = Setting::where('key', 'productId')->pluck('value')->first();
        $tokenTapin = Setting::where('key' , 'tokenTapin')->pluck('value')->first();
        $shopTapin = Setting::where('key' , 'shopTapin')->pluck('value')->first();
        if($request->title or $request->image or $request->body or $request->summery){
            $request->validate([
                'title' => 'required|max:220',
                'image' => 'required',
                'status' => 'required',
                'count' => 'required|integer|digits_between: 1,5',
                'price' => 'required|integer|digits_between: 1,9',
                'weight' => 'required|integer|digits_between: 1,9',
            ]);
            if ($request->off){
                $price = round($request->price - $request->price * $request->off / 100);
            }else{
                $price = $request->price;
            }
            $productIds = Post::buildCode();
            $pi = $productId . '-' . $productIds;
            if ($tokenTapin){
                $params = array(
                    "shop_id"=> $shopTapin,
                    "title"=> $request->title,
                    "price"=> $price,
                    "weight"=> $request->weight,
                    "description"=> $request->body,
                    "category_id"=>"919d814a-5996-479f-8215-fa4395e17300"
                );
                $ch = curl_init();
                curl_setopt($ch, CURLOPT_URL, 'https://api.tapin.ir/api/v2/public/product/create/');
                curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($params));
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
                curl_setopt($ch, CURLOPT_HTTPHEADER, array(
                    'Content-Type: application/json',
                    "Authorization: $tokenTapin",
                ));

                $result = curl_exec($ch);
                curl_close($ch);
                $contents = json_decode($result,true);
                $pi = $contents['entries']['product_id'];
            }
            $post = Post::create([
                'body' => $request->summery,
                'count' => $request->count,
                'title' => $request->title,
                'meta' => $request->meta,
                'titleEn' => $request->titleEn,
                'showcase' => $request->showcase,
                'used' => $request->used,
                'original' => $request->original,
                'status' => $request->status,
                'slug' => $request->slug,
                'image' => $request->image,
                'weight' => $request->weight,
                'price' => $price,
                'offPrice' => $request->price,
                'off' => $request->off,
                'suggest' => $request->suggest,
                'user_id' => auth()->user()->id,
                'product_id' => $pi,
            ]);
            $meta = Review::create([
                'body' => $request->body,
                'rate' => $request->allRate,
                'ability' => $request->allAbility,
                'size' => $request->allSize,
                'specifications' => $request->allProperty,
                'colors' => $request->allColor,
            ]);
            $post->review()->sync($meta->id);
            $post->category()->sync($request->allCategory);
            $post->brand()->sync($request->allBrand);
            $post->guarantee()->sync($request->allGuarantee);
            $post->time()->sync($request->allTime);
            $post->country()->sync($request->allCountry);
        }
        $categories = Category::latest()->pluck('name', 'id');
        $brands = Brand::latest()->pluck('name', 'id');
        $guarantees = Guarantee::latest()->pluck('name', 'id');
        $countries = Country::latest()->pluck('name' , 'id');
        $times = Time::latest()->pluck('name', 'id');
        return Inertia::render('Post/PostCreate', [
            'categories' => $categories,
            'times' => $times,
            'brands' => $brands,
            'countries' => $countries,
            'guarantees' => $guarantees,
        ]);
    }


    public function show(Post $post)
    {
        $users = User::get();
        foreach ($users as $user) {
            if (Cache::has('user-is-online-' . $user->id)) {
                $user->update([
                    'activity' => Verta::now()->format('H:i Y-n-j')
                ]);
            }
        }
        $payMeta = PayMeta::where('post_id' , $post->id)->with('user','pay','guarantee')->paginate(20);
        $reply = Setting::where('key' , 'replyComment')->pluck('value')->first();
        $coercion = Setting::where('key' , 'coercionComment')->pluck('value')->first();
        $showUser = Setting::where('key' , 'showUserComment')->pluck('value')->first();
        $checkOnline = Setting::where('key' , 'checkOnlineComment')->pluck('value')->first();
        $posts = Post::where('id',$post->id)->with('review' , 'user')->withCount('bookmark' , 'review' , 'like' , 'view' , 'comments')->first();
        return Inertia::render('Post/ShowPost' , [
            'payMeta' => $payMeta,
            'posts' => $posts,
            'reply' => $reply,
            'coercion' => $coercion,
            'showUser' => $showUser,
            'checkOnline' => $checkOnline,
        ]);
    }


    public function edit(Post $post , Request $request){
        if($request->title or $request->image or $request->body or $request->summery){
            $request->validate([
                'title' => 'required',
                'count' => 'required',
                'image' => 'required',
                'price' => 'required',
                'weight' => 'required',
            ]);

            if ($request->off){
                $price = round($request->price - $request->price * $request->off / 100);
            }else{
                $price = $request->price;
            }
            $post->update([
                'body' => $request->summery,
                'count' => $request->count,
                'title' => $request->title,
                'titleEn' => $request->titleEn,
                'showcase' => $request->showcase,
                'meta' => $request->meta,
                'used' => $request->used,
                'weight' => $request->weight,
                'original' => $request->original,
                'status' => $request->status,
                'slug' => $request->slug,
                'image' => $request->image,
                'price' => $price,
                'offPrice' => $request->price,
                'off' => $request->off,
                'suggest' => $request->suggest,
                'updated_at'=> Carbon::now(),
            ]);
            $post->review()->first()->update([
                'body' => $request->body,
                'rate' => $request->allRate,
                'ability' => $request->allAbility,
                'size' => $request->allSize,
                'specifications' => $request->allProperty,
                'colors' => $request->allColor,
            ]);
            $post->category()->detach();
            $post->brand()->detach();
            $post->guarantee()->detach();
            $post->time()->detach();
            $post->country()->detach();
            $post->category()->sync($request->allCategory);
            $post->brand()->sync($request->allBrand);
            $post->guarantee()->sync($request->allGuarantee);
            $post->time()->sync($request->allTime);
            $post->country()->sync($request->allCountry);
//            if($post->suggest){
//                $reports = Report::where('reportable_id' , $post->id)->where('type',2)->get();
//                $address1 = Setting::where('key' , 'address')->pluck('value')->first();
//                $address = $address1 . 'product/' .$post->slug;
//                foreach ($reports as $item){
//                    $user = User::where('id' , $item->user_id)->first();
//                    foreach (json_decode($item->data , true) as $value){
//                        if($value == 'ایمیل'){
//                            if($user->email){
//                                $message = "<strong>سلام و درود خدمت شما دوست عزیز</strong><br>محصول $post->title <br> در پیشنهاد شگفت انگیز قرار گرفته است <br><a href='$address '>مشاهده محصول</a><br><br>";
//                                $this->sendEmail($user->email , $message , 'شگفت انگیز ها');
//                            }
//                        }
//                        if($value == 'پیامک'){
//                            if($user->number){
//                                $message = "سلام و درود خدمت شما دوست عزیز\n محصول  $post->title\nدر پیشنهاد شگفت انگیز قرار گرفته است";
//                                $this->sendSms("$user->number" , $message,env('GHASEDAKAPI_Number'));
//                            }
//                        }
//
//                    }
//                }
//            }
        }
        $categories = Category::latest()->pluck('name' , 'id');
        $brands = Brand::latest()->pluck('name' , 'id');
        $guarantees = Guarantee::latest()->pluck('name' , 'id');
        $countries = Country::latest()->pluck('name' , 'id');
        $times = Time::latest()->pluck('name' , 'id');
        $posts = Post::where('id' , $post->id)->with('review','country','guarantee','category','time','brand')->first();
        return Inertia::render('Post/EditPost', [
            'categories' => $categories,
            'countries' => $countries,
            'posts' => $posts,
            'times' => $times,
            'brands' => $brands,
            'guarantees' => $guarantees,
        ]);
    }
}
