<?php

namespace App\Http\Controllers\Home;

use App\Http\Controllers\Controller;
use App\Models\Brand;
use App\Models\Category;
use App\Models\Checkout;
use App\Models\Company;
use App\Models\Document;
use App\Models\Event;
use App\Models\Guarantee;
use App\Models\PayMeta;
use App\Models\Post;
use App\Models\Report;
use App\Models\Review;
use App\Models\Setting;
use App\Models\Time;
use App\Models\User;
use App\Models\UserMeta;
use App\Traits\SendEmailTrait;
use App\Traits\SendSmsTrait;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Inertia\Inertia;

class SellerController extends Controller
{
    use SendSmsTrait;
    use SendEmailTrait;
    public function __construct()
    {
        $this->middleware('auth');
    }
    public function profile(){
        $posts = Post::latest()->where('user_id' , auth()->user()->id)->where('type',0)->pluck('id');
        $pays = PayMeta::latest()->whereIn('post_id' , $posts)->where('status' , 100)->with('post','pay','user')->take(10)->get();
        $paycount = PayMeta::latest()->whereIn('post_id' , $posts)->where('status' , 100)->pluck('price')->sum();
        $postcount = Post::latest()->where('user_id' , auth()->user()->id)->where('type',0)->count();
        $checksum = Checkout::where('user_id' , auth()->user()->id)->where('status' , 2)->latest()->pluck('price')->sum();
        $posts = Post::latest()->where('user_id' , auth()->user()->id)->where('type',0)->take(10)->get();
        return view('home.seller.index',compact('pays','paycount','postcount','checksum','posts'));
    }

    public function createProduct(){
        $categories = Category::latest()->pluck('name', 'id');
        $brands = Brand::latest()->pluck('name', 'id');
        $guarantees = Guarantee::latest()->pluck('name', 'id');
        $times = Time::latest()->pluck('name', 'id');
        return view('home.seller.createProduct',compact('categories','brands','guarantees','times'));
    }

    public function addProduct(Request $request){
        $productId = Setting::where('key', 'productId')->pluck('value')->first();
        $request->validate([
            'title' => 'required|max:220',
            'image' => 'required',
            'summery' => 'required',
            'count' => 'required|integer|digits_between: 1,5',
            'price' => 'required|integer|digits_between: 1,9',
        ]);
        if ($request->off){
            $price = round($request->price - $request->price * $request->off / 100);
        }else{
            $price = $request->price;
        }
        $productIds = Post::buildCode();
        $post = Post::create([
            'body' => $request->summery,
            'count' => $request->count,
            'title' => $request->title,
            'titleEn' => $request->titleEn,
            'showcase' => 0,
            'used' => $request->used,
            'original' => $request->original,
            'status' => 0,
            'slug' => $request->slug,
            'image' => $request->image,
            'price' => $price,
            'offPrice' => $request->price,
            'off' => $request->off,
            'user_id' => auth()->user()->id,
            'product_id' => $productId . '-' . $productIds,
        ]);
        $meta = Review::create([
            'body' => $request->body,
            'rate' => $request->allRate,
            'ability' => $request->allAbility,
            'size' => $request->allSize,
            'specifications' => $request->allProperty,
            'colors' => $request->allColor,
        ]);
        $post->review()->sync($meta->id);
        $post->category()->sync($request->allCategory);
        $post->brand()->sync($request->allBrand);
        $post->guarantee()->sync($request->allGuarantee);
        $post->time()->sync($request->allTime);
        return 'success';
    }

    public function editProduct(Post $post){
        $categories = Category::latest()->pluck('name' , 'id');
        $brands = Brand::latest()->pluck('name' , 'id');
        $guarantees = Guarantee::latest()->pluck('name' , 'id');
        $times = Time::latest()->pluck('name' , 'id');
        $posts = Post::where('id' , $post->id)->with('review','guarantee','category','time','brand')->first();
        return view('home.seller.editProduct',compact('categories','posts','brands','guarantees','times'));
    }

    public function allMyProduct(){
        $posts = Post::latest()->where('user_id' , auth()->user()->id)->with('category')->withCount('post')->paginate(60);
        return view('home.seller.allMyProduct',compact('posts'));
    }

    public function allProduct(){
        $posts = Post::latest()->where('user_id' , auth()->user()->id)->where('variety' , 0)->where('status' , 1)->with('category')->withCount('post')->paginate(60);
        return view('home.seller.allProduct',compact('posts'));
    }

    public function checkout(){
        $posts = Post::where('user_id' , auth()->user()->id)->latest()->where('status' , 1)->pluck('id')->toArray();
        $allpays = PayMeta::whereIn('post_id' , $posts)->where('status' , 100)->pluck('price')->sum();
        $checksum = Checkout::where('user_id' , auth()->user()->id)->where('status' , 2)->latest()->pluck('price')->sum();
        $check = Checkout::where('user_id' , auth()->user()->id)->latest()->get();
        $exist = Checkout::where('user_id' , auth()->user()->id)->where('status' , 0)->latest()->first();
        return view('home.seller.checkout' , compact('check','exist','checksum','allpays'));
    }

    public function checkoutStore(){
        if (auth()->user()->shaba){
            $posts = Post::where('user_id' , auth()->user()->id)->latest()->where('status' , 1)->pluck('id')->toArray();
            $allPays = PayMeta::whereIn('post_id' , $posts)->where('status' , 100)->pluck('price')->sum();
            $checkSum = Checkout::where('user_id' , auth()->user()->id)->where('status' , 2)->latest()->pluck('price')->sum();
            return Checkout::create([
                'price' => (int)$allPays - (int)$checkSum,
                'user_id' => auth()->user()->id,
                'shaba' => auth()->user()->shaba,
                'status' => 0,
            ]);
        }else{
            return 'shaba';
        }
    }

    public function pay(){
        $posts = Post::where('user_id' , auth()->user()->id)->latest()->where('status' , 1)->pluck('id')->toArray();
        $allpays = PayMeta::whereIn('post_id' , $posts)->where('status' , 100)->pluck('price')->sum();
        $today = PayMeta::whereDate('created_at',Carbon::today())->whereIn('post_id' , $posts)->where('status' , 100)->pluck('price')->sum();
        $week = PayMeta::whereBetween('created_at', [Carbon::now()->startOfWeek(), Carbon::now()->endOfWeek()])->whereIn('post_id' , $posts)->where('status' , 100)->pluck('price')->sum();
        $pays = PayMeta::latest()->whereIn('post_id' , $posts)->whereIn('status' , [100,50])->with('post','pay','user')->paginate(25);
        return view('home.seller.pay' , compact('today','week','pays','allpays'));
    }

    public function addVariety(Post $post){
        $posts = Post::where('id' , $post->id)->with('review','category','guarantee')->first();
        $guarantees = Guarantee::latest()->pluck('name', 'id');
        return view('home.seller.addVariety',compact('guarantees' , 'posts'));
    }

    public function addVarietyStore(Request $request , Post $post){
        $request->validate([
            'count' => 'required|integer|digits_between: 1,5',
            'price' => 'required|integer|digits_between: 1,9',
        ]);
        $posts = Post::where('id' , $post->id)->with('review','category','guarantee')->with(["post" => function($q){
            $q->where('status' ,1)->with('user','review','guarantee');
        }])->first();
        if ($request->off){
            $price = round($request->price - $request->price * $request->off / 100);
        }else{
            $price = $request->price;
        }
        $productIds = Post::buildCode();
        $productId = Setting::where('key', 'productId')->pluck('value')->first();
        $variety = Post::create([
            'body' => $posts->summery,
            'bodyEn' => $posts->summeryEn,
            'count' => $request->count,
            'title' => $posts->title,
            'titleEn' => $posts->titleEn,
            'showcase' => 0,
            'used' => $posts->used,
            'original' => $posts->original,
            'status' => 0,
            'variety' => 1,
            'slug' => $posts->slug,
            'image' => $posts->image,
            'price' => $price,
            'offPrice' => $request->price,
            'off' => $request->off,
            'suggest' => null,
            'user_id' => auth()->user()->id,
            'product_id' => $productId . '-' . $productIds,
        ]);
        $meta = Review::create([
            'body' => $posts['review'][0]['body'],
            'bodyEn' => $posts['review'][0]['bodyEn'],
            'rate' => $posts['review'][0]['allRate'],
            'ability' => $posts['review'][0]['allAbility'],
            'size' => $request->allSize,
            'specifications' => $posts['review'][0]['allProperty'],
            'colors' => $request->allColor,
        ]);
        $variety->review()->sync($meta->id);
        $variety->guarantee()->sync($request->allGuarantee);
        $post->post()->attach($variety->id);
        return 'success';
    }

    public function showPay(Request $request , PayMeta $payMeta){
        $pay1 = PayMeta::where('id' , $payMeta->id)->with('pay','post')->with(["user" => function ($q) {
            $q->with('userMeta');
        }])->first();
        $pay2 = $payMeta->pay()->with('address')->first();
        return [$pay1,$pay2];
    }

    public function editVariety(Post $post){
        $posts = Post::where('id' , $post->id)->where('variety' , 1)->with('review','category','guarantee')->first();
        $guarantees = Guarantee::latest()->pluck('name', 'id');
        return view('home.seller.editVariety',compact('guarantees' , 'posts'));
    }

    public function editVarietyStore(Post $post , Request $request){
        $request->validate([
            'count' => 'required|integer|digits_between: 1,5',
            'price' => 'required|integer|digits_between: 1,9',
        ]);
        $variety = $post->update([
            'count' => $request->count,
            'offPrice' => $request->price,
            'off' => $request->off,
        ]);
        $post->review()->first()->update([
            'size' => $request->allSize,
            'colors' => $request->allColor,
        ]);
        $post->guarantee()->detach();
        $post->guarantee()->sync($request->allGuarantee);
        return 'success';
    }

    public function searchProduct(Request $request){
        $product = Post::where("title" , "LIKE" , "%{$request->search}%")->where('variety' , 0)->with('category')->where('status' , 1)->paginate(60);
        if(count($product) == 0){
            $product = Post::where("product_id" , "LIKE" , "%{$request->search}%")->with('category')->where('variety' , 0)->where('status' , 1)->paginate(60);
        }
        return $product;
    }

    public function searchMyProduct(Request $request){
        $product = Post::where("title" , "LIKE" , "%{$request->search}%")->with('category')->where('status' , 1)->paginate(60);
        if(count($product) == 0){
            $product = Post::where("product_id" , "LIKE" , "%{$request->search}%")->with('category')->where('status' , 1)->paginate(60);
        }
        return $product;
    }

    public function becomeSeller(){
        $users = User::where('id' , auth()->user()->id)->with('userMeta','company')->first();
        $documents = Document::latest()->where('user_id' , auth()->user()->id)->get();
        return view('home.seller.become',compact('documents','users'));
    }

    public function becomeSellerStore(Request $request){
        if ($request->level == 1){
            if($request->seller){
                $request->validate([
                    'post' => 'required|min:10|max:10',
                    'residenceAddress' => 'required|max:255',
                    'landlinePhone' => 'required|max:11',
                    'number' => 'required',
                    'email' => 'required',
                    'companyName' => 'required|max:150',
                    'registrationNumber' => 'required|min:12|max:12',
                    'nationalID' => 'required|min:11|max:11',
                    'signatureOwners' => 'required|max:255',
                    'economicCode' => 'required|min:12|max:12',
                    'shaba' => 'required|max:26',
                    'userName' => 'required|max:255|unique:users,name',
                    'seller' => 'required',
                    'type' => 'required',
                ]);
                auth()->user()->update([
                    'name' => $request->userName,
                    'seller' => $request->seller,
                    'shaba' => $request->shaba,
                    'landlinePhone'=>$request->landlinePhone,
                ]);
                $check = Auth::user()->company()->count();
                if ($check >= 1){
                    Auth::user()->company()->update([
                        'name' => $request->companyName,
                        'type' => $request->type,
                        'registration' => $request->registrationNumber,
                        'NationalID' => $request->nationalID,
                        'economicCode' => $request->economicCode,
                        'signer' => $request->signatureOwners,
                        'residenceAddress' => $request->residenceAddress,
                    ]);
                    Event::create([
                        'type' => 11,
                        'title' => 'تغییر اطلاعات کاربر',
                        'user_id' => auth()->user()->id,
                        'description' => 'کاربر با نام ' . auth()->user()->name . 'اطلاعات خود را تغییر داد',
                    ]);
                }
                else{
                    Company::create([
                        'name' => $request->companyName,
                        'type' => $request->type,
                        'registration' => $request->registrationNumber,
                        'NationalID' => $request->nationalID,
                        'economicCode' => $request->economicCode,
                        'signer' => $request->signatureOwners,
                        'residenceAddress' => $request->residenceAddress,
                        'user_id' => auth()->user()->id,
                    ]);
                    Event::create([
                        'type' => 12,
                        'title' => 'تکمیل اطلاعات کاربر',
                        'user_id' => auth()->user()->id,
                        'description' => 'کاربر با نام ' . auth()->user()->name . 'اطلاعات خود را تکمیل کرد',
                    ]);
                }
            }
            else{
                $request->validate([
                    'code' => 'required|min:10|max:11',
                    'name' => 'required|max:255',
                    'post' => 'required|min:10|max:10',
                    'dateBirth' => 'required|max:11',
                    'residenceAddress' => 'required|max:255',
                    'landlinePhone' => 'required|min:10|max:11',
                    'number' => 'required',
                    'email' => 'required',
                    'shaba' => 'required|max:26',
                    'userName' => 'required|max:255',
                    'seller' => 'required',
                    'gender' => 'required',
                ]);
                auth()->user()->update([
                    'name' => $request->userName,
                    'shaba' => $request->shaba,
                    'seller' => $request->seller,
                    'landlinePhone'=>$request->landlinePhone,
                ]);
                $check = Auth::user()->userMeta()->count();
                if ($check >= 1){
                    Auth::user()->userMeta()->first()->update([
                        'date'=>$request->dateBirth,
                        'name'=>$request->name,
                        'post'=>$request->post,
                        'gender'=>$request->gender,
                        'code'=>$request->code,
                        'residenceAddress' => $request->residenceAddress,
                    ]);
                    Event::create([
                        'type' => 11,
                        'title' => 'تغییر اطلاعات کاربر',
                        'user_id' => auth()->user()->id,
                        'description' => 'کاربر با نام ' . auth()->user()->name . 'اطلاعات خود را تغییر داد',
                    ]);
                }
                else{
                    $userMeta = UserMeta::create([
                        'date'=>$request->dateBirth,
                        'name'=>$request->name,
                        'post'=>$request->post,
                        'landlinePhone'=>$request->landlinePhone,
                        'gender'=>$request->gender,
                        'code'=>$request->code,
                        'residenceAddress' => $request->residenceAddress,
                    ]);
                    Event::create([
                        'type' => 12,
                        'title' => 'تکمیل اطلاعات کاربر',
                        'user_id' => auth()->user()->id,
                        'description' => 'کاربر با نام ' . auth()->user()->name . 'اطلاعات خود را تکمیل کرد',
                    ]);
                    Auth::user()->userMeta()->sync($userMeta->id);
                }
            }
            $levels = 2;
        }elseif($request->level == 2){
            $request->validate([
                'frontImage' => 'required|max:100',
                'backImage' => 'required|max:100',
                'number' => 'required',
                'email' => 'required',
            ]);
            Document::create([
                'status' => 0,
                'frontNaturalId' => $request->frontImage,
                'backNaturalId' => $request->backImage,
                'user_id' => auth()->user()->id,
            ]);
            Event::create([
                'type' => 14,
                'title' => 'ارسال مدارک',
                'user_id' => auth()->user()->id,
                'description' => 'کاربر با نام ' . auth()->user()->name . 'مدارک خود را ارسال کرد',
            ]);
            $levels = 3;
        }elseif($request->level == 3){
            $request->validate([
                'number' => 'required',
                'email' => 'required',
            ]);
            $check = Document::latest()->where('status' , 2)->where('user_id' , auth()->user()->id)->first();
            if($check){
                auth()->user()->givePermissionTo('فروشنده');
            }
            $levels = 4;
        }else{
            $documents = Document::latest()->where('user_id' , auth()->user()->id)->get();
            if(count($documents) >= 1){
                $showSome =  auth()->user()->getAllPermissions()->where('name' , 'فروشنده')->pluck('name')->first();
                if($showSome){
                    $levels = 4;
                }else{
                    $levels = 3;
                }
            }else{
                $levels = 1;
            }
        }
        return $levels;
    }
}
