<?php

namespace App\Http\Controllers\Home;

use App\Http\Controllers\Controller;
use App\Models\News;
use App\Models\Post;
use App\Models\Report;
use App\Models\Setting;
use App\Models\User;
use App\Models\Vidget;
use App\Models\View;
use App\Traits\SeoHelper;
use Carbon\Carbon;
use Hekmatinasser\Verta\Verta;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Inertia\Inertia;
use Jenssegers\Agent\Agent;

class SingleController extends Controller
{
    use SeoHelper;
    public function product(Post $post){
        $address = Setting::where('key' , 'address')->pluck('value')->first();
        $name = Setting::where('key' , 'name')->pluck('value')->first();
        $title = Setting::where('key' , 'title')->pluck('value')->first();
        $this->seoSingleSeo(   $post->title . " - $title " , $post->body , 'store' , 'product/'."$post->slug" , json_decode($post->image)[0] );


        $time = Carbon::now()->format('Y-m-d h:i');
        DB::table('posts')->where('suggest', '<=' , $time)->update(['suggest'=> null]);

        $approve = Setting::where('key' , 'approved')->pluck('value')->first();
        if ($approve == 0){
            $posts = Post::where('id' , $post->id)->with('guarantee' , 'country' , 'review' , 'category' , 'brand')->with(["question" => function($q){
                $q->where('parent_id' , 0)->where('approved', '=', 1)->with(["questions" => function($q){
                    $q->where('approved', '=', 1);
                }]);
            }])->withCount(["rate" => function ($q) {
                $q->select(DB::raw('round(avg(rate_post),1)'));
            }])->with(["comments" => function($q){
                $q->where('parent_id' , 0);
            }])->first();
        }else{
            $posts = Post::where('id' , $post->id)->with('guarantee' , 'country' , 'review' , 'category' , 'brand')->with(["question" => function($q){
                $q->where('parent_id' , 0)->where('approved', '=', 1)->with(["questions" => function($q){
                    $q->where('approved', '=', 1);
                }]);
            }])->withCount(["rate" => function ($q) {
                $q->select(DB::raw('round(avg(rate_post),1)'));
            }])->with(["comments" => function($q){
                $q->where('parent_id' , 0)->where('approved', '=', 1);
            }])->first();
        }

        $showPostCategory = Setting::where('key' , 'showPostCategory')->pluck('value')->first();

        $related =  Post::whereHas('category', function ($q) use ($post){
            return $q->whereIn('name', $post->category()->pluck('name'));
        })->where('id' , '!=' , $post->id)->where('type' , 0)->where('status' , 1)->take($showPostCategory)->get();

        $show1 = Setting::where('key' , 'checkUser')->pluck('value')->first();
        if ($show1 == 1){
            if (auth()->user()){
                $show = true;
            }else{
                $show = false;
            }
        }else{
            $show = true;
        }

        if (auth()->user()){
            $feedback1 = Report::where('user_id' , auth()->user()->id)->where('reportable_id', $post->id)->where('reportable_type', 'App\\Models\\Post')->where('type' , 1)->first();
            $notification1 = Report::where('user_id' , auth()->user()->id)->where('reportable_id', $post->id)->where('reportable_type', 'App\\Models\\Post')->where('type' , 2)->first();
            if($feedback1){
                $feedback = 1;
            }else{
                $feedback = 0;
            }
            if($notification1){
                $notification = 1;
            }else{
                $notification = 0;
            }
        }else{
            $feedback = 0;
            $notification= 0;
        }
        $sellers = [];
        array_push($sellers , $post->user()->select(['id' ,'name','reference','supply','commitment'])->first());
        $users = $post->post;
        if(!empty($users)){
            foreach($users as $item){
                array_push($sellers , $item->user()->select(['id' ,'name','reference','supply','commitment'])->first());
            }
        }
        if(!empty($posts->review[0]['colors'])){
            $colorseller = json_decode($posts->review[0]['colors']);
        }else{
            $colorseller = [];
        }
        if(!empty($posts->review[0]['size'])){
            $sizeseller = json_decode($posts->review[0]['size']);
        }else{
            $sizeseller = [];
        }
        $guaranteeseller = $posts->guarantee;

        $priceseller = $post->price;
        $reply = Setting::where('key' , 'reply')->pluck('value')->first();
        $coercion = Setting::where('key' , 'coercion')->pluck('value')->first();
        $showuser = Setting::where('key' , 'showUser')->pluck('value')->first();
        $checkonline = Setting::where('key' , 'checkOnline')->pluck('value')->first();
        return view('home.single.product' , compact('address','guaranteeseller','sellers','priceseller','colorseller','sizeseller','notification','feedback','reply','coercion','showuser','checkonline','posts','related'));
    }
    public function changeSeller(Request $request){
        $user = User::where('id' , $request->seller)->first();
        return $user->post()->with('review','guarantee')->first();
    }
    public function view(Request $request){
        $check = 'no';
        $agent = new Agent();
        $platform = $agent->platform();
        $browser = $agent->browser();
        $user_ip = $request->ip();
        $views = View::where('user_ip' , $user_ip)->whereDate('created_at' , Carbon::today())->get();
        for ( $i = 0; $i < count($views); $i++) {
            $views1 = $views[$i]->post()->where('id' , $request->postId)->first();
            if ($views1){
                $check = 'yes';
            }
        }
        if ($check == 'no'){
            $view = View::create([
                'browser'=>$browser,
                'platform'=>$platform,
                'user_ip'=>$user_ip,
            ]);
            $view->post()->sync($request->postId);
            if (auth()->user()){
                $view->user()->sync(auth()->user()->id);
            }
        }
    }
    public function news(News $news){
        $title = Setting::where('key' , 'title')->pluck('value')->first();
        $this->seoSingleSeo(   $news->title . " - $title " , $news->body , 'store' , 'blog/'."$news->slug" , $news->image );
        $related =  News::whereHas('category', function ($q) use ($news){
            return $q->whereIn('name', $news->category()->pluck('name'));
        })->where('id' , '!=' , $news->id)->where('status' , 1)->take(6)->get();
        $suggest = News::where('suggest',1)->inRandomOrder()->where('status',1)->latest()->get();
        $post = News::where('id',$news->id)->with('user','category','tag')->first();
        return view('home.single.news' , compact('related','suggest','post'));
    }
    public function seller(User $user){
        $title = Setting::where('key' , 'title')->pluck('value')->first();
        $this->seoSingleSeo(   $user->name . " - $title " , $user->body , 'store' , '/'."$user->slug" , $user->profile );
        $seller = User::with('post')->where('id',$user->id)->first();
        $map = Setting::where('key' , 'map')->pluck('value')->first();
        return view('home.single.seller' , compact('seller','map'));
    }
}
