require('./bootstrap');

import Vue from 'vue';

import { InertiaApp } from '@inertiajs/inertia-vue';
import { InertiaForm } from 'laravel-jetstream';
import PortalVue from 'portal-vue';
import VueSweetalert2 from 'vue-sweetalert2';
import 'sweetalert2/dist/sweetalert2.min.css';
import { InertiaProgress } from '@inertiajs/progress';
import VueMeta from 'vue-meta';
import fullscreen from 'vue-fullscreen'
import EventHub from 'vue-event-hub';
import CKEditor from '@ckeditor/ckeditor5-vue2';
import VuePersianDatetimePicker from 'vue-persian-datetime-picker';
Vue.use(VueSweetalert2);
Vue.mixin({ methods: { route } });
Vue.use(InertiaApp);
Vue.use(InertiaForm);
Vue.use(PortalVue);
Vue.use(fullscreen)
Vue.use(EventHub);
Vue.use( CKEditor );
Vue.component('date-picker', VuePersianDatetimePicker);
InertiaProgress.init({
    // The delay after which the progress bar will
    // appear during navigation, in milliseconds.
    delay: 250,

    // The color of the progress bar.
    color: '#F71938',

    // Whether to include the default NProgress styles.
    includeCSS: true,

    // Whether the NProgress spinner will be shown.
    showSpinner: false,
})

Vue.use(VueMeta, {
    refreshOnceOnNavigation: false
});
const app = document.getElementById('app');

new Vue({
    render: (h) =>
        h(InertiaApp, {
            props: {
                initialPage: JSON.parse(app.dataset.page),
                resolveComponent: (name) => require(`./Pages/Admin/${name}`).default,
            },
        }),
}).$mount(app);


Vue.filter('NumFormat', function(value) {
    if(!value) return '0';
    value = `${value}`;
    var intPart = Number(value).toFixed(0);
    var intPartFormat = intPart.toString().replace(/(\d)(?=(?:\d{3})+$)/g, '$1,');
    var floatPart = "";
    var value2Array = value.split(".");
    if(value2Array.length == 2) {
        floatPart = value2Array[1].toString();
        if(floatPart.length == 1) {
            return intPartFormat + "." + floatPart + '0';
        } else {
            return intPartFormat + "." + floatPart;
        }
    } else {
        return intPartFormat + floatPart;
    }
})
